package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.SyntheticLicenseServiceConfigurationString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LicenseServiceConfiguration(
    endpoint: Optional[SyntheticLicenseServiceConfigurationString] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.LicenseServiceConfiguration = {
    import LicenseServiceConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.LicenseServiceConfiguration
      .builder()
      .optionallyWith(
        endpoint.map(value =>
          SyntheticLicenseServiceConfigurationString.unwrap(
            value
          ): java.lang.String
        )
      )(_.endpoint)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.LicenseServiceConfiguration.ReadOnly =
    zio.aws.nimble.model.LicenseServiceConfiguration.wrap(buildAwsValue())
}
object LicenseServiceConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.LicenseServiceConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.LicenseServiceConfiguration =
      zio.aws.nimble.model
        .LicenseServiceConfiguration(endpoint.map(value => value))
    def endpoint: Optional[SyntheticLicenseServiceConfigurationString]
    def getEndpoint
        : ZIO[Any, AwsError, SyntheticLicenseServiceConfigurationString] =
      AwsError.unwrapOptionField("endpoint", endpoint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.LicenseServiceConfiguration
  ) extends zio.aws.nimble.model.LicenseServiceConfiguration.ReadOnly {
    override val endpoint
        : Optional[SyntheticLicenseServiceConfigurationString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpoint())
        .map(value =>
          zio.aws.nimble.model.primitives
            .SyntheticLicenseServiceConfigurationString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.LicenseServiceConfiguration
  ): zio.aws.nimble.model.LicenseServiceConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
