package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.ClientToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateLaunchProfileMemberRequest(
    clientToken: Option[ClientToken] = None,
    launchProfileId: String,
    persona: zio.aws.nimble.model.LaunchProfilePersona,
    principalId: String,
    studioId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.UpdateLaunchProfileMemberRequest = {
    import UpdateLaunchProfileMemberRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.UpdateLaunchProfileMemberRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .launchProfileId(launchProfileId: java.lang.String)
      .persona(persona.unwrap)
      .principalId(principalId: java.lang.String)
      .studioId(studioId: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.nimble.model.UpdateLaunchProfileMemberRequest.ReadOnly =
    zio.aws.nimble.model.UpdateLaunchProfileMemberRequest.wrap(buildAwsValue())
}
object UpdateLaunchProfileMemberRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.UpdateLaunchProfileMemberRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.UpdateLaunchProfileMemberRequest =
      zio.aws.nimble.model.UpdateLaunchProfileMemberRequest(
        clientToken.map(value => value),
        launchProfileId,
        persona,
        principalId,
        studioId
      )
    def clientToken: Option[ClientToken]
    def launchProfileId: String
    def persona: zio.aws.nimble.model.LaunchProfilePersona
    def principalId: String
    def studioId: String
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getLaunchProfileId: ZIO[Any, Nothing, String] =
      ZIO.succeed(launchProfileId)
    def getPersona
        : ZIO[Any, Nothing, zio.aws.nimble.model.LaunchProfilePersona] =
      ZIO.succeed(persona)
    def getPrincipalId: ZIO[Any, Nothing, String] = ZIO.succeed(principalId)
    def getStudioId: ZIO[Any, Nothing, String] = ZIO.succeed(studioId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.UpdateLaunchProfileMemberRequest
  ) extends zio.aws.nimble.model.UpdateLaunchProfileMemberRequest.ReadOnly {
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.nimble.model.primitives.ClientToken(value))
    override val launchProfileId: String = impl.launchProfileId(): String
    override val persona: zio.aws.nimble.model.LaunchProfilePersona =
      zio.aws.nimble.model.LaunchProfilePersona.wrap(impl.persona())
    override val principalId: String = impl.principalId(): String
    override val studioId: String = impl.studioId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.UpdateLaunchProfileMemberRequest
  ): zio.aws.nimble.model.UpdateLaunchProfileMemberRequest.ReadOnly =
    new Wrapper(impl)
}
