package zio.aws.nimble.model
import scala.jdk.CollectionConverters._
sealed trait StudioState {
  def unwrap: software.amazon.awssdk.services.nimble.model.StudioState
}
object StudioState {
  def wrap(
      value: software.amazon.awssdk.services.nimble.model.StudioState
  ): zio.aws.nimble.model.StudioState = value match {
    case software.amazon.awssdk.services.nimble.model.StudioState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.nimble.model.StudioState.CREATE_IN_PROGRESS =>
      val r = CREATE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.nimble.model.StudioState.READY =>
      val r = READY
      r
    case software.amazon.awssdk.services.nimble.model.StudioState.UPDATE_IN_PROGRESS =>
      val r = UPDATE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.nimble.model.StudioState.DELETE_IN_PROGRESS =>
      val r = DELETE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.nimble.model.StudioState.DELETED =>
      val r = DELETED
      r
    case software.amazon.awssdk.services.nimble.model.StudioState.DELETE_FAILED =>
      val r = DELETE_FAILED
      r
    case software.amazon.awssdk.services.nimble.model.StudioState.CREATE_FAILED =>
      val r = CREATE_FAILED
      r
    case software.amazon.awssdk.services.nimble.model.StudioState.UPDATE_FAILED =>
      val r = UPDATE_FAILED
      r
  }
  case object unknownToSdkVersion extends zio.aws.nimble.model.StudioState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioState =
      software.amazon.awssdk.services.nimble.model.StudioState.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATE_IN_PROGRESS extends zio.aws.nimble.model.StudioState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioState =
      software.amazon.awssdk.services.nimble.model.StudioState.CREATE_IN_PROGRESS
  }
  case object READY extends zio.aws.nimble.model.StudioState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioState =
      software.amazon.awssdk.services.nimble.model.StudioState.READY
  }
  case object UPDATE_IN_PROGRESS extends zio.aws.nimble.model.StudioState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioState =
      software.amazon.awssdk.services.nimble.model.StudioState.UPDATE_IN_PROGRESS
  }
  case object DELETE_IN_PROGRESS extends zio.aws.nimble.model.StudioState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioState =
      software.amazon.awssdk.services.nimble.model.StudioState.DELETE_IN_PROGRESS
  }
  case object DELETED extends zio.aws.nimble.model.StudioState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioState =
      software.amazon.awssdk.services.nimble.model.StudioState.DELETED
  }
  case object DELETE_FAILED extends zio.aws.nimble.model.StudioState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioState =
      software.amazon.awssdk.services.nimble.model.StudioState.DELETE_FAILED
  }
  case object CREATE_FAILED extends zio.aws.nimble.model.StudioState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioState =
      software.amazon.awssdk.services.nimble.model.StudioState.CREATE_FAILED
  }
  case object UPDATE_FAILED extends zio.aws.nimble.model.StudioState {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StudioState =
      software.amazon.awssdk.services.nimble.model.StudioState.UPDATE_FAILED
  }
}
