package zio.aws.nimble.model
import java.lang.Integer
import zio.aws.nimble.model.primitives.MaxResults
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListLaunchProfileMembersRequest(
    launchProfileId: String,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[String] = None,
    studioId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.ListLaunchProfileMembersRequest = {
    import ListLaunchProfileMembersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.ListLaunchProfileMembersRequest
      .builder()
      .launchProfileId(launchProfileId: java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .studioId(studioId: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.nimble.model.ListLaunchProfileMembersRequest.ReadOnly =
    zio.aws.nimble.model.ListLaunchProfileMembersRequest.wrap(buildAwsValue())
}
object ListLaunchProfileMembersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.ListLaunchProfileMembersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.ListLaunchProfileMembersRequest =
      zio.aws.nimble.model.ListLaunchProfileMembersRequest(
        launchProfileId,
        maxResults.map(value => value),
        nextToken.map(value => value),
        studioId
      )
    def launchProfileId: String
    def maxResults: Option[MaxResults]
    def nextToken: Option[String]
    def studioId: String
    def getLaunchProfileId: ZIO[Any, Nothing, String] =
      ZIO.succeed(launchProfileId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getStudioId: ZIO[Any, Nothing, String] = ZIO.succeed(studioId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.ListLaunchProfileMembersRequest
  ) extends zio.aws.nimble.model.ListLaunchProfileMembersRequest.ReadOnly {
    override val launchProfileId: String = impl.launchProfileId(): String
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.nimble.model.primitives.MaxResults(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val studioId: String = impl.studioId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.ListLaunchProfileMembersRequest
  ): zio.aws.nimble.model.ListLaunchProfileMembersRequest.ReadOnly =
    new Wrapper(impl)
}
