package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListEulasRequest(
    eulaIds: Option[Iterable[String]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.ListEulasRequest = {
    import ListEulasRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.ListEulasRequest
      .builder()
      .optionallyWith(
        eulaIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.eulaIds)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.ListEulasRequest.ReadOnly =
    zio.aws.nimble.model.ListEulasRequest.wrap(buildAwsValue())
}
object ListEulasRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.ListEulasRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.ListEulasRequest =
      zio.aws.nimble.model.ListEulasRequest(
        eulaIds.map(value => value),
        nextToken.map(value => value)
      )
    def eulaIds: Option[List[String]]
    def nextToken: Option[String]
    def getEulaIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("eulaIds", eulaIds)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.ListEulasRequest
  ) extends zio.aws.nimble.model.ListEulasRequest.ReadOnly {
    override val eulaIds: Option[List[String]] = scala
      .Option(impl.eulaIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.ListEulasRequest
  ): zio.aws.nimble.model.ListEulasRequest.ReadOnly = new Wrapper(impl)
}
