package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetStudioMemberResponse(
    member: Option[zio.aws.nimble.model.StudioMembership] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.GetStudioMemberResponse = {
    import GetStudioMemberResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.GetStudioMemberResponse
      .builder()
      .optionallyWith(member.map(value => value.buildAwsValue()))(_.member)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.GetStudioMemberResponse.ReadOnly =
    zio.aws.nimble.model.GetStudioMemberResponse.wrap(buildAwsValue())
}
object GetStudioMemberResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.GetStudioMemberResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.GetStudioMemberResponse =
      zio.aws.nimble.model
        .GetStudioMemberResponse(member.map(value => value.asEditable))
    def member: Option[zio.aws.nimble.model.StudioMembership.ReadOnly]
    def getMember
        : ZIO[Any, AwsError, zio.aws.nimble.model.StudioMembership.ReadOnly] =
      AwsError.unwrapOptionField("member", member)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.GetStudioMemberResponse
  ) extends zio.aws.nimble.model.GetStudioMemberResponse.ReadOnly {
    override val member
        : Option[zio.aws.nimble.model.StudioMembership.ReadOnly] = scala
      .Option(impl.member())
      .map(value => zio.aws.nimble.model.StudioMembership.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.GetStudioMemberResponse
  ): zio.aws.nimble.model.GetStudioMemberResponse.ReadOnly = new Wrapper(impl)
}
