package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetStreamingSessionStreamRequest(
    sessionId: String,
    streamId: String,
    studioId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.GetStreamingSessionStreamRequest = {
    import GetStreamingSessionStreamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.GetStreamingSessionStreamRequest
      .builder()
      .sessionId(sessionId: java.lang.String)
      .streamId(streamId: java.lang.String)
      .studioId(studioId: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.nimble.model.GetStreamingSessionStreamRequest.ReadOnly =
    zio.aws.nimble.model.GetStreamingSessionStreamRequest.wrap(buildAwsValue())
}
object GetStreamingSessionStreamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.GetStreamingSessionStreamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.GetStreamingSessionStreamRequest =
      zio.aws.nimble.model
        .GetStreamingSessionStreamRequest(sessionId, streamId, studioId)
    def sessionId: String
    def streamId: String
    def studioId: String
    def getSessionId: ZIO[Any, Nothing, String] = ZIO.succeed(sessionId)
    def getStreamId: ZIO[Any, Nothing, String] = ZIO.succeed(streamId)
    def getStudioId: ZIO[Any, Nothing, String] = ZIO.succeed(studioId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.GetStreamingSessionStreamRequest
  ) extends zio.aws.nimble.model.GetStreamingSessionStreamRequest.ReadOnly {
    override val sessionId: String = impl.sessionId(): String
    override val streamId: String = impl.streamId(): String
    override val studioId: String = impl.studioId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.GetStreamingSessionStreamRequest
  ): zio.aws.nimble.model.GetStreamingSessionStreamRequest.ReadOnly =
    new Wrapper(impl)
}
