package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.ClientToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteStudioComponentRequest(
    clientToken: Option[ClientToken] = None,
    studioComponentId: String,
    studioId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.DeleteStudioComponentRequest = {
    import DeleteStudioComponentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.DeleteStudioComponentRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .studioComponentId(studioComponentId: java.lang.String)
      .studioId(studioId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.DeleteStudioComponentRequest.ReadOnly =
    zio.aws.nimble.model.DeleteStudioComponentRequest.wrap(buildAwsValue())
}
object DeleteStudioComponentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.DeleteStudioComponentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.DeleteStudioComponentRequest =
      zio.aws.nimble.model.DeleteStudioComponentRequest(
        clientToken.map(value => value),
        studioComponentId,
        studioId
      )
    def clientToken: Option[ClientToken]
    def studioComponentId: String
    def studioId: String
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getStudioComponentId: ZIO[Any, Nothing, String] =
      ZIO.succeed(studioComponentId)
    def getStudioId: ZIO[Any, Nothing, String] = ZIO.succeed(studioId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.DeleteStudioComponentRequest
  ) extends zio.aws.nimble.model.DeleteStudioComponentRequest.ReadOnly {
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.nimble.model.primitives.ClientToken(value))
    override val studioComponentId: String = impl.studioComponentId(): String
    override val studioId: String = impl.studioId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.DeleteStudioComponentRequest
  ): zio.aws.nimble.model.DeleteStudioComponentRequest.ReadOnly = new Wrapper(
    impl
  )
}
