package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.ClientToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteStreamingSessionRequest(
    clientToken: Option[ClientToken] = None,
    sessionId: String,
    studioId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.DeleteStreamingSessionRequest = {
    import DeleteStreamingSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.DeleteStreamingSessionRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .sessionId(sessionId: java.lang.String)
      .studioId(studioId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.DeleteStreamingSessionRequest.ReadOnly =
    zio.aws.nimble.model.DeleteStreamingSessionRequest.wrap(buildAwsValue())
}
object DeleteStreamingSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.DeleteStreamingSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.DeleteStreamingSessionRequest =
      zio.aws.nimble.model.DeleteStreamingSessionRequest(
        clientToken.map(value => value),
        sessionId,
        studioId
      )
    def clientToken: Option[ClientToken]
    def sessionId: String
    def studioId: String
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getSessionId: ZIO[Any, Nothing, String] = ZIO.succeed(sessionId)
    def getStudioId: ZIO[Any, Nothing, String] = ZIO.succeed(studioId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.DeleteStreamingSessionRequest
  ) extends zio.aws.nimble.model.DeleteStreamingSessionRequest.ReadOnly {
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.nimble.model.primitives.ClientToken(value))
    override val sessionId: String = impl.sessionId(): String
    override val studioId: String = impl.studioId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.DeleteStreamingSessionRequest
  ): zio.aws.nimble.model.DeleteStreamingSessionRequest.ReadOnly = new Wrapper(
    impl
  )
}
