package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.ClientToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteStreamingImageRequest(
    clientToken: Option[ClientToken] = None,
    streamingImageId: String,
    studioId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.DeleteStreamingImageRequest = {
    import DeleteStreamingImageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.DeleteStreamingImageRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .streamingImageId(streamingImageId: java.lang.String)
      .studioId(studioId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.DeleteStreamingImageRequest.ReadOnly =
    zio.aws.nimble.model.DeleteStreamingImageRequest.wrap(buildAwsValue())
}
object DeleteStreamingImageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.DeleteStreamingImageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.DeleteStreamingImageRequest =
      zio.aws.nimble.model.DeleteStreamingImageRequest(
        clientToken.map(value => value),
        streamingImageId,
        studioId
      )
    def clientToken: Option[ClientToken]
    def streamingImageId: String
    def studioId: String
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getStreamingImageId: ZIO[Any, Nothing, String] =
      ZIO.succeed(streamingImageId)
    def getStudioId: ZIO[Any, Nothing, String] = ZIO.succeed(studioId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.DeleteStreamingImageRequest
  ) extends zio.aws.nimble.model.DeleteStreamingImageRequest.ReadOnly {
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.nimble.model.primitives.ClientToken(value))
    override val streamingImageId: String = impl.streamingImageId(): String
    override val studioId: String = impl.studioId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.DeleteStreamingImageRequest
  ): zio.aws.nimble.model.DeleteStreamingImageRequest.ReadOnly = new Wrapper(
    impl
  )
}
