package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.{
  StudioComponentName,
  SecurityGroupId,
  StudioComponentDescription,
  ClientToken
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateStudioComponentRequest(
    clientToken: Option[ClientToken] = None,
    configuration: Option[zio.aws.nimble.model.StudioComponentConfiguration] =
      None,
    description: Option[StudioComponentDescription] = None,
    ec2SecurityGroupIds: Option[Iterable[SecurityGroupId]] = None,
    initializationScripts: Option[
      Iterable[zio.aws.nimble.model.StudioComponentInitializationScript]
    ] = None,
    name: StudioComponentName,
    scriptParameters: Option[
      Iterable[zio.aws.nimble.model.ScriptParameterKeyValue]
    ] = None,
    studioId: String,
    subtype: Option[zio.aws.nimble.model.StudioComponentSubtype] = None,
    tags: Option[Map[String, String]] = None,
    `type`: zio.aws.nimble.model.StudioComponentType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.CreateStudioComponentRequest = {
    import CreateStudioComponentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.CreateStudioComponentRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .optionallyWith(
        description.map(value =>
          StudioComponentDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        ec2SecurityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ec2SecurityGroupIds)
      .optionallyWith(
        initializationScripts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.initializationScripts)
      .name(StudioComponentName.unwrap(name): java.lang.String)
      .optionallyWith(
        scriptParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scriptParameters)
      .studioId(studioId: java.lang.String)
      .optionallyWith(subtype.map(value => value.unwrap))(_.subtype)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.CreateStudioComponentRequest.ReadOnly =
    zio.aws.nimble.model.CreateStudioComponentRequest.wrap(buildAwsValue())
}
object CreateStudioComponentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.CreateStudioComponentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.CreateStudioComponentRequest =
      zio.aws.nimble.model.CreateStudioComponentRequest(
        clientToken.map(value => value),
        configuration.map(value => value.asEditable),
        description.map(value => value),
        ec2SecurityGroupIds.map(value => value),
        initializationScripts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        name,
        scriptParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        studioId,
        subtype.map(value => value),
        tags.map(value => value),
        `type`
      )
    def clientToken: Option[ClientToken]
    def configuration
        : Option[zio.aws.nimble.model.StudioComponentConfiguration.ReadOnly]
    def description: Option[StudioComponentDescription]
    def ec2SecurityGroupIds: Option[List[SecurityGroupId]]
    def initializationScripts: Option[
      List[zio.aws.nimble.model.StudioComponentInitializationScript.ReadOnly]
    ]
    def name: StudioComponentName
    def scriptParameters
        : Option[List[zio.aws.nimble.model.ScriptParameterKeyValue.ReadOnly]]
    def studioId: String
    def subtype: Option[zio.aws.nimble.model.StudioComponentSubtype]
    def tags: Option[Map[String, String]]
    def `type`: zio.aws.nimble.model.StudioComponentType
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.nimble.model.StudioComponentConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("configuration", configuration)
    def getDescription: ZIO[Any, AwsError, StudioComponentDescription] =
      AwsError.unwrapOptionField("description", description)
    def getEc2SecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("ec2SecurityGroupIds", ec2SecurityGroupIds)
    def getInitializationScripts: ZIO[Any, AwsError, List[
      zio.aws.nimble.model.StudioComponentInitializationScript.ReadOnly
    ]] =
      AwsError.unwrapOptionField("initializationScripts", initializationScripts)
    def getName: ZIO[Any, Nothing, StudioComponentName] = ZIO.succeed(name)
    def getScriptParameters: ZIO[Any, AwsError, List[
      zio.aws.nimble.model.ScriptParameterKeyValue.ReadOnly
    ]] = AwsError.unwrapOptionField("scriptParameters", scriptParameters)
    def getStudioId: ZIO[Any, Nothing, String] = ZIO.succeed(studioId)
    def getSubtype
        : ZIO[Any, AwsError, zio.aws.nimble.model.StudioComponentSubtype] =
      AwsError.unwrapOptionField("subtype", subtype)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
    def getType: ZIO[Any, Nothing, zio.aws.nimble.model.StudioComponentType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.CreateStudioComponentRequest
  ) extends zio.aws.nimble.model.CreateStudioComponentRequest.ReadOnly {
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.nimble.model.primitives.ClientToken(value))
    override val configuration
        : Option[zio.aws.nimble.model.StudioComponentConfiguration.ReadOnly] =
      scala
        .Option(impl.configuration())
        .map(value =>
          zio.aws.nimble.model.StudioComponentConfiguration.wrap(value)
        )
    override val description: Option[StudioComponentDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.nimble.model.primitives.StudioComponentDescription(value)
      )
    override val ec2SecurityGroupIds: Option[List[SecurityGroupId]] = scala
      .Option(impl.ec2SecurityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.nimble.model.primitives.SecurityGroupId(item)
        }.toList
      )
    override val initializationScripts: Option[
      List[zio.aws.nimble.model.StudioComponentInitializationScript.ReadOnly]
    ] = scala
      .Option(impl.initializationScripts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.nimble.model.StudioComponentInitializationScript.wrap(item)
        }.toList
      )
    override val name: StudioComponentName =
      zio.aws.nimble.model.primitives.StudioComponentName(impl.name())
    override val scriptParameters
        : Option[List[zio.aws.nimble.model.ScriptParameterKeyValue.ReadOnly]] =
      scala
        .Option(impl.scriptParameters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.nimble.model.ScriptParameterKeyValue.wrap(item)
          }.toList
        )
    override val studioId: String = impl.studioId(): String
    override val subtype: Option[zio.aws.nimble.model.StudioComponentSubtype] =
      scala
        .Option(impl.subtype())
        .map(value => zio.aws.nimble.model.StudioComponentSubtype.wrap(value))
    override val tags: Option[Map[String, String]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val `type`: zio.aws.nimble.model.StudioComponentType =
      zio.aws.nimble.model.StudioComponentType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.CreateStudioComponentRequest
  ): zio.aws.nimble.model.CreateStudioComponentRequest.ReadOnly = new Wrapper(
    impl
  )
}
