package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateStreamingImageResponse(
    streamingImage: Option[zio.aws.nimble.model.StreamingImage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.CreateStreamingImageResponse = {
    import CreateStreamingImageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.CreateStreamingImageResponse
      .builder()
      .optionallyWith(streamingImage.map(value => value.buildAwsValue()))(
        _.streamingImage
      )
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.CreateStreamingImageResponse.ReadOnly =
    zio.aws.nimble.model.CreateStreamingImageResponse.wrap(buildAwsValue())
}
object CreateStreamingImageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.CreateStreamingImageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.CreateStreamingImageResponse =
      zio.aws.nimble.model.CreateStreamingImageResponse(
        streamingImage.map(value => value.asEditable)
      )
    def streamingImage: Option[zio.aws.nimble.model.StreamingImage.ReadOnly]
    def getStreamingImage
        : ZIO[Any, AwsError, zio.aws.nimble.model.StreamingImage.ReadOnly] =
      AwsError.unwrapOptionField("streamingImage", streamingImage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.CreateStreamingImageResponse
  ) extends zio.aws.nimble.model.CreateStreamingImageResponse.ReadOnly {
    override val streamingImage
        : Option[zio.aws.nimble.model.StreamingImage.ReadOnly] = scala
      .Option(impl.streamingImage())
      .map(value => zio.aws.nimble.model.StreamingImage.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.CreateStreamingImageResponse
  ): zio.aws.nimble.model.CreateStreamingImageResponse.ReadOnly = new Wrapper(
    impl
  )
}
