package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.ClientToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AcceptEulasRequest(
    clientToken: Option[ClientToken] = None,
    eulaIds: Option[Iterable[String]] = None,
    studioId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.AcceptEulasRequest = {
    import AcceptEulasRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.AcceptEulasRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        eulaIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.eulaIds)
      .studioId(studioId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.AcceptEulasRequest.ReadOnly =
    zio.aws.nimble.model.AcceptEulasRequest.wrap(buildAwsValue())
}
object AcceptEulasRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.AcceptEulasRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.AcceptEulasRequest =
      zio.aws.nimble.model.AcceptEulasRequest(
        clientToken.map(value => value),
        eulaIds.map(value => value),
        studioId
      )
    def clientToken: Option[ClientToken]
    def eulaIds: Option[List[String]]
    def studioId: String
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getEulaIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("eulaIds", eulaIds)
    def getStudioId: ZIO[Any, Nothing, String] = ZIO.succeed(studioId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.AcceptEulasRequest
  ) extends zio.aws.nimble.model.AcceptEulasRequest.ReadOnly {
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.nimble.model.primitives.ClientToken(value))
    override val eulaIds: Option[List[String]] = scala
      .Option(impl.eulaIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val studioId: String = impl.studioId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.AcceptEulasRequest
  ): zio.aws.nimble.model.AcceptEulasRequest.ReadOnly = new Wrapper(impl)
}
