package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.{
  SecurityGroupId,
  Timestamp,
  StudioComponentDescription,
  StudioComponentName,
  StudioComponentId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class StudioComponent(
    arn: Option[String] = None,
    configuration: Option[zio.aws.nimble.model.StudioComponentConfiguration] =
      None,
    createdAt: Option[Timestamp] = None,
    createdBy: Option[String] = None,
    description: Option[StudioComponentDescription] = None,
    ec2SecurityGroupIds: Option[Iterable[SecurityGroupId]] = None,
    initializationScripts: Option[
      Iterable[zio.aws.nimble.model.StudioComponentInitializationScript]
    ] = None,
    name: Option[StudioComponentName] = None,
    scriptParameters: Option[
      Iterable[zio.aws.nimble.model.ScriptParameterKeyValue]
    ] = None,
    state: Option[zio.aws.nimble.model.StudioComponentState] = None,
    statusCode: Option[zio.aws.nimble.model.StudioComponentStatusCode] = None,
    statusMessage: Option[String] = None,
    studioComponentId: Option[StudioComponentId] = None,
    subtype: Option[zio.aws.nimble.model.StudioComponentSubtype] = None,
    tags: Option[Map[String, String]] = None,
    `type`: Option[zio.aws.nimble.model.StudioComponentType] = None,
    updatedAt: Option[Timestamp] = None,
    updatedBy: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.StudioComponent = {
    import StudioComponent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.StudioComponent
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(createdBy.map(value => value: java.lang.String))(
        _.createdBy
      )
      .optionallyWith(
        description.map(value =>
          StudioComponentDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        ec2SecurityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ec2SecurityGroupIds)
      .optionallyWith(
        initializationScripts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.initializationScripts)
      .optionallyWith(
        name.map(value => StudioComponentName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        scriptParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scriptParameters)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(statusCode.map(value => value.unwrap))(_.statusCode)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(
        studioComponentId.map(value =>
          StudioComponentId.unwrap(value): java.lang.String
        )
      )(_.studioComponentId)
      .optionallyWith(subtype.map(value => value.unwrap))(_.subtype)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(updatedBy.map(value => value: java.lang.String))(
        _.updatedBy
      )
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.StudioComponent.ReadOnly =
    zio.aws.nimble.model.StudioComponent.wrap(buildAwsValue())
}
object StudioComponent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.StudioComponent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.StudioComponent =
      zio.aws.nimble.model.StudioComponent(
        arn.map(value => value),
        configuration.map(value => value.asEditable),
        createdAt.map(value => value),
        createdBy.map(value => value),
        description.map(value => value),
        ec2SecurityGroupIds.map(value => value),
        initializationScripts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        name.map(value => value),
        scriptParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        state.map(value => value),
        statusCode.map(value => value),
        statusMessage.map(value => value),
        studioComponentId.map(value => value),
        subtype.map(value => value),
        tags.map(value => value),
        `type`.map(value => value),
        updatedAt.map(value => value),
        updatedBy.map(value => value)
      )
    def arn: Option[String]
    def configuration
        : Option[zio.aws.nimble.model.StudioComponentConfiguration.ReadOnly]
    def createdAt: Option[Timestamp]
    def createdBy: Option[String]
    def description: Option[StudioComponentDescription]
    def ec2SecurityGroupIds: Option[List[SecurityGroupId]]
    def initializationScripts: Option[
      List[zio.aws.nimble.model.StudioComponentInitializationScript.ReadOnly]
    ]
    def name: Option[StudioComponentName]
    def scriptParameters
        : Option[List[zio.aws.nimble.model.ScriptParameterKeyValue.ReadOnly]]
    def state: Option[zio.aws.nimble.model.StudioComponentState]
    def statusCode: Option[zio.aws.nimble.model.StudioComponentStatusCode]
    def statusMessage: Option[String]
    def studioComponentId: Option[StudioComponentId]
    def subtype: Option[zio.aws.nimble.model.StudioComponentSubtype]
    def tags: Option[Map[String, String]]
    def `type`: Option[zio.aws.nimble.model.StudioComponentType]
    def updatedAt: Option[Timestamp]
    def updatedBy: Option[String]
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.nimble.model.StudioComponentConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("configuration", configuration)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getCreatedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getDescription: ZIO[Any, AwsError, StudioComponentDescription] =
      AwsError.unwrapOptionField("description", description)
    def getEc2SecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("ec2SecurityGroupIds", ec2SecurityGroupIds)
    def getInitializationScripts: ZIO[Any, AwsError, List[
      zio.aws.nimble.model.StudioComponentInitializationScript.ReadOnly
    ]] =
      AwsError.unwrapOptionField("initializationScripts", initializationScripts)
    def getName: ZIO[Any, AwsError, StudioComponentName] =
      AwsError.unwrapOptionField("name", name)
    def getScriptParameters: ZIO[Any, AwsError, List[
      zio.aws.nimble.model.ScriptParameterKeyValue.ReadOnly
    ]] = AwsError.unwrapOptionField("scriptParameters", scriptParameters)
    def getState
        : ZIO[Any, AwsError, zio.aws.nimble.model.StudioComponentState] =
      AwsError.unwrapOptionField("state", state)
    def getStatusCode
        : ZIO[Any, AwsError, zio.aws.nimble.model.StudioComponentStatusCode] =
      AwsError.unwrapOptionField("statusCode", statusCode)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getStudioComponentId: ZIO[Any, AwsError, StudioComponentId] =
      AwsError.unwrapOptionField("studioComponentId", studioComponentId)
    def getSubtype
        : ZIO[Any, AwsError, zio.aws.nimble.model.StudioComponentSubtype] =
      AwsError.unwrapOptionField("subtype", subtype)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
    def getType: ZIO[Any, AwsError, zio.aws.nimble.model.StudioComponentType] =
      AwsError.unwrapOptionField("type", `type`)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getUpdatedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("updatedBy", updatedBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.StudioComponent
  ) extends zio.aws.nimble.model.StudioComponent.ReadOnly {
    override val arn: Option[String] =
      scala.Option(impl.arn()).map(value => value: String)
    override val configuration
        : Option[zio.aws.nimble.model.StudioComponentConfiguration.ReadOnly] =
      scala
        .Option(impl.configuration())
        .map(value =>
          zio.aws.nimble.model.StudioComponentConfiguration.wrap(value)
        )
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.nimble.model.primitives.Timestamp(value))
    override val createdBy: Option[String] =
      scala.Option(impl.createdBy()).map(value => value: String)
    override val description: Option[StudioComponentDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.nimble.model.primitives.StudioComponentDescription(value)
      )
    override val ec2SecurityGroupIds: Option[List[SecurityGroupId]] = scala
      .Option(impl.ec2SecurityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.nimble.model.primitives.SecurityGroupId(item)
        }.toList
      )
    override val initializationScripts: Option[
      List[zio.aws.nimble.model.StudioComponentInitializationScript.ReadOnly]
    ] = scala
      .Option(impl.initializationScripts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.nimble.model.StudioComponentInitializationScript.wrap(item)
        }.toList
      )
    override val name: Option[StudioComponentName] = scala
      .Option(impl.name())
      .map(value => zio.aws.nimble.model.primitives.StudioComponentName(value))
    override val scriptParameters
        : Option[List[zio.aws.nimble.model.ScriptParameterKeyValue.ReadOnly]] =
      scala
        .Option(impl.scriptParameters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.nimble.model.ScriptParameterKeyValue.wrap(item)
          }.toList
        )
    override val state: Option[zio.aws.nimble.model.StudioComponentState] =
      scala
        .Option(impl.state())
        .map(value => zio.aws.nimble.model.StudioComponentState.wrap(value))
    override val statusCode
        : Option[zio.aws.nimble.model.StudioComponentStatusCode] = scala
      .Option(impl.statusCode())
      .map(value => zio.aws.nimble.model.StudioComponentStatusCode.wrap(value))
    override val statusMessage: Option[String] =
      scala.Option(impl.statusMessage()).map(value => value: String)
    override val studioComponentId: Option[StudioComponentId] = scala
      .Option(impl.studioComponentId())
      .map(value => zio.aws.nimble.model.primitives.StudioComponentId(value))
    override val subtype: Option[zio.aws.nimble.model.StudioComponentSubtype] =
      scala
        .Option(impl.subtype())
        .map(value => zio.aws.nimble.model.StudioComponentSubtype.wrap(value))
    override val tags: Option[Map[String, String]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val `type`: Option[zio.aws.nimble.model.StudioComponentType] =
      scala
        .Option(impl.`type`())
        .map(value => zio.aws.nimble.model.StudioComponentType.wrap(value))
    override val updatedAt: Option[Timestamp] = scala
      .Option(impl.updatedAt())
      .map(value => zio.aws.nimble.model.primitives.Timestamp(value))
    override val updatedBy: Option[String] =
      scala.Option(impl.updatedBy()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.StudioComponent
  ): zio.aws.nimble.model.StudioComponent.ReadOnly = new Wrapper(impl)
}
