package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StartStreamingSessionResponse(
    session: Option[zio.aws.nimble.model.StreamingSession] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.StartStreamingSessionResponse = {
    import StartStreamingSessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.StartStreamingSessionResponse
      .builder()
      .optionallyWith(session.map(value => value.buildAwsValue()))(_.session)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.StartStreamingSessionResponse.ReadOnly =
    zio.aws.nimble.model.StartStreamingSessionResponse.wrap(buildAwsValue())
}
object StartStreamingSessionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.StartStreamingSessionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.StartStreamingSessionResponse =
      zio.aws.nimble.model
        .StartStreamingSessionResponse(session.map(value => value.asEditable))
    def session: Option[zio.aws.nimble.model.StreamingSession.ReadOnly]
    def getSession
        : ZIO[Any, AwsError, zio.aws.nimble.model.StreamingSession.ReadOnly] =
      AwsError.unwrapOptionField("session", session)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.StartStreamingSessionResponse
  ) extends zio.aws.nimble.model.StartStreamingSessionResponse.ReadOnly {
    override val session
        : Option[zio.aws.nimble.model.StreamingSession.ReadOnly] = scala
      .Option(impl.session())
      .map(value => zio.aws.nimble.model.StreamingSession.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.StartStreamingSessionResponse
  ): zio.aws.nimble.model.StartStreamingSessionResponse.ReadOnly = new Wrapper(
    impl
  )
}
