package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListStudioMembersResponse(
    members: Option[Iterable[zio.aws.nimble.model.StudioMembership]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.ListStudioMembersResponse = {
    import ListStudioMembersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.ListStudioMembersResponse
      .builder()
      .optionallyWith(
        members.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.members)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.ListStudioMembersResponse.ReadOnly =
    zio.aws.nimble.model.ListStudioMembersResponse.wrap(buildAwsValue())
}
object ListStudioMembersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.ListStudioMembersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.ListStudioMembersResponse =
      zio.aws.nimble.model.ListStudioMembersResponse(
        members.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def members: Option[List[zio.aws.nimble.model.StudioMembership.ReadOnly]]
    def nextToken: Option[String]
    def getMembers: ZIO[Any, AwsError, List[
      zio.aws.nimble.model.StudioMembership.ReadOnly
    ]] = AwsError.unwrapOptionField("members", members)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.ListStudioMembersResponse
  ) extends zio.aws.nimble.model.ListStudioMembersResponse.ReadOnly {
    override val members
        : Option[List[zio.aws.nimble.model.StudioMembership.ReadOnly]] = scala
      .Option(impl.members())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.nimble.model.StudioMembership.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.ListStudioMembersResponse
  ): zio.aws.nimble.model.ListStudioMembersResponse.ReadOnly = new Wrapper(impl)
}
