package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.{
  LaunchProfileName,
  EC2SubnetId,
  LaunchProfileId,
  Timestamp,
  LaunchProfileDescription,
  LaunchProfileProtocolVersion
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class LaunchProfile(
    arn: Option[String] = None,
    createdAt: Option[Timestamp] = None,
    createdBy: Option[String] = None,
    description: Option[LaunchProfileDescription] = None,
    ec2SubnetIds: Option[Iterable[EC2SubnetId]] = None,
    launchProfileId: Option[LaunchProfileId] = None,
    launchProfileProtocolVersions: Option[
      Iterable[LaunchProfileProtocolVersion]
    ] = None,
    name: Option[LaunchProfileName] = None,
    state: Option[zio.aws.nimble.model.LaunchProfileState] = None,
    statusCode: Option[zio.aws.nimble.model.LaunchProfileStatusCode] = None,
    statusMessage: Option[String] = None,
    streamConfiguration: Option[zio.aws.nimble.model.StreamConfiguration] =
      None,
    studioComponentIds: Option[Iterable[String]] = None,
    tags: Option[Map[String, String]] = None,
    updatedAt: Option[Timestamp] = None,
    updatedBy: Option[String] = None,
    validationResults: Option[Iterable[zio.aws.nimble.model.ValidationResult]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.LaunchProfile = {
    import LaunchProfile.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.LaunchProfile
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(createdBy.map(value => value: java.lang.String))(
        _.createdBy
      )
      .optionallyWith(
        description.map(value =>
          LaunchProfileDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        ec2SubnetIds.map(value =>
          value.map { item =>
            EC2SubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ec2SubnetIds)
      .optionallyWith(
        launchProfileId.map(value =>
          LaunchProfileId.unwrap(value): java.lang.String
        )
      )(_.launchProfileId)
      .optionallyWith(
        launchProfileProtocolVersions.map(value =>
          value.map { item =>
            LaunchProfileProtocolVersion.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.launchProfileProtocolVersions)
      .optionallyWith(
        name.map(value => LaunchProfileName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(statusCode.map(value => value.unwrap))(_.statusCode)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(streamConfiguration.map(value => value.buildAwsValue()))(
        _.streamConfiguration
      )
      .optionallyWith(
        studioComponentIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.studioComponentIds)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(updatedBy.map(value => value: java.lang.String))(
        _.updatedBy
      )
      .optionallyWith(
        validationResults.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.validationResults)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.LaunchProfile.ReadOnly =
    zio.aws.nimble.model.LaunchProfile.wrap(buildAwsValue())
}
object LaunchProfile {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.LaunchProfile
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.LaunchProfile =
      zio.aws.nimble.model.LaunchProfile(
        arn.map(value => value),
        createdAt.map(value => value),
        createdBy.map(value => value),
        description.map(value => value),
        ec2SubnetIds.map(value => value),
        launchProfileId.map(value => value),
        launchProfileProtocolVersions.map(value => value),
        name.map(value => value),
        state.map(value => value),
        statusCode.map(value => value),
        statusMessage.map(value => value),
        streamConfiguration.map(value => value.asEditable),
        studioComponentIds.map(value => value),
        tags.map(value => value),
        updatedAt.map(value => value),
        updatedBy.map(value => value),
        validationResults.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def arn: Option[String]
    def createdAt: Option[Timestamp]
    def createdBy: Option[String]
    def description: Option[LaunchProfileDescription]
    def ec2SubnetIds: Option[List[EC2SubnetId]]
    def launchProfileId: Option[LaunchProfileId]
    def launchProfileProtocolVersions
        : Option[List[LaunchProfileProtocolVersion]]
    def name: Option[LaunchProfileName]
    def state: Option[zio.aws.nimble.model.LaunchProfileState]
    def statusCode: Option[zio.aws.nimble.model.LaunchProfileStatusCode]
    def statusMessage: Option[String]
    def streamConfiguration
        : Option[zio.aws.nimble.model.StreamConfiguration.ReadOnly]
    def studioComponentIds: Option[List[String]]
    def tags: Option[Map[String, String]]
    def updatedAt: Option[Timestamp]
    def updatedBy: Option[String]
    def validationResults
        : Option[List[zio.aws.nimble.model.ValidationResult.ReadOnly]]
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getCreatedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getDescription: ZIO[Any, AwsError, LaunchProfileDescription] =
      AwsError.unwrapOptionField("description", description)
    def getEc2SubnetIds: ZIO[Any, AwsError, List[EC2SubnetId]] =
      AwsError.unwrapOptionField("ec2SubnetIds", ec2SubnetIds)
    def getLaunchProfileId: ZIO[Any, AwsError, LaunchProfileId] =
      AwsError.unwrapOptionField("launchProfileId", launchProfileId)
    def getLaunchProfileProtocolVersions
        : ZIO[Any, AwsError, List[LaunchProfileProtocolVersion]] =
      AwsError.unwrapOptionField(
        "launchProfileProtocolVersions",
        launchProfileProtocolVersions
      )
    def getName: ZIO[Any, AwsError, LaunchProfileName] =
      AwsError.unwrapOptionField("name", name)
    def getState: ZIO[Any, AwsError, zio.aws.nimble.model.LaunchProfileState] =
      AwsError.unwrapOptionField("state", state)
    def getStatusCode
        : ZIO[Any, AwsError, zio.aws.nimble.model.LaunchProfileStatusCode] =
      AwsError.unwrapOptionField("statusCode", statusCode)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getStreamConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.nimble.model.StreamConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("streamConfiguration", streamConfiguration)
    def getStudioComponentIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("studioComponentIds", studioComponentIds)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getUpdatedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("updatedBy", updatedBy)
    def getValidationResults: ZIO[Any, AwsError, List[
      zio.aws.nimble.model.ValidationResult.ReadOnly
    ]] = AwsError.unwrapOptionField("validationResults", validationResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.LaunchProfile
  ) extends zio.aws.nimble.model.LaunchProfile.ReadOnly {
    override val arn: Option[String] =
      scala.Option(impl.arn()).map(value => value: String)
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.nimble.model.primitives.Timestamp(value))
    override val createdBy: Option[String] =
      scala.Option(impl.createdBy()).map(value => value: String)
    override val description: Option[LaunchProfileDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.nimble.model.primitives.LaunchProfileDescription(value)
      )
    override val ec2SubnetIds: Option[List[EC2SubnetId]] = scala
      .Option(impl.ec2SubnetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.nimble.model.primitives.EC2SubnetId(item)
        }.toList
      )
    override val launchProfileId: Option[LaunchProfileId] = scala
      .Option(impl.launchProfileId())
      .map(value => zio.aws.nimble.model.primitives.LaunchProfileId(value))
    override val launchProfileProtocolVersions
        : Option[List[LaunchProfileProtocolVersion]] = scala
      .Option(impl.launchProfileProtocolVersions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.nimble.model.primitives.LaunchProfileProtocolVersion(item)
        }.toList
      )
    override val name: Option[LaunchProfileName] = scala
      .Option(impl.name())
      .map(value => zio.aws.nimble.model.primitives.LaunchProfileName(value))
    override val state: Option[zio.aws.nimble.model.LaunchProfileState] = scala
      .Option(impl.state())
      .map(value => zio.aws.nimble.model.LaunchProfileState.wrap(value))
    override val statusCode
        : Option[zio.aws.nimble.model.LaunchProfileStatusCode] = scala
      .Option(impl.statusCode())
      .map(value => zio.aws.nimble.model.LaunchProfileStatusCode.wrap(value))
    override val statusMessage: Option[String] =
      scala.Option(impl.statusMessage()).map(value => value: String)
    override val streamConfiguration
        : Option[zio.aws.nimble.model.StreamConfiguration.ReadOnly] = scala
      .Option(impl.streamConfiguration())
      .map(value => zio.aws.nimble.model.StreamConfiguration.wrap(value))
    override val studioComponentIds: Option[List[String]] = scala
      .Option(impl.studioComponentIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val tags: Option[Map[String, String]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val updatedAt: Option[Timestamp] = scala
      .Option(impl.updatedAt())
      .map(value => zio.aws.nimble.model.primitives.Timestamp(value))
    override val updatedBy: Option[String] =
      scala.Option(impl.updatedBy()).map(value => value: String)
    override val validationResults
        : Option[List[zio.aws.nimble.model.ValidationResult.ReadOnly]] = scala
      .Option(impl.validationResults())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.nimble.model.ValidationResult.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.LaunchProfile
  ): zio.aws.nimble.model.LaunchProfile.ReadOnly = new Wrapper(impl)
}
