package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetStudioMemberRequest(principalId: String, studioId: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.GetStudioMemberRequest = {
    import GetStudioMemberRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.GetStudioMemberRequest
      .builder()
      .principalId(principalId: java.lang.String)
      .studioId(studioId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.GetStudioMemberRequest.ReadOnly =
    zio.aws.nimble.model.GetStudioMemberRequest.wrap(buildAwsValue())
}
object GetStudioMemberRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.GetStudioMemberRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.GetStudioMemberRequest =
      zio.aws.nimble.model.GetStudioMemberRequest(principalId, studioId)
    def principalId: String
    def studioId: String
    def getPrincipalId: ZIO[Any, Nothing, String] = ZIO.succeed(principalId)
    def getStudioId: ZIO[Any, Nothing, String] = ZIO.succeed(studioId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.GetStudioMemberRequest
  ) extends zio.aws.nimble.model.GetStudioMemberRequest.ReadOnly {
    override val principalId: String = impl.principalId(): String
    override val studioId: String = impl.studioId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.GetStudioMemberRequest
  ): zio.aws.nimble.model.GetStudioMemberRequest.ReadOnly = new Wrapper(impl)
}
