package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetLaunchProfileDetailsResponse(
    launchProfile: Option[zio.aws.nimble.model.LaunchProfile] = None,
    streamingImages: Option[Iterable[zio.aws.nimble.model.StreamingImage]] =
      None,
    studioComponentSummaries: Option[
      Iterable[zio.aws.nimble.model.StudioComponentSummary]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.GetLaunchProfileDetailsResponse = {
    import GetLaunchProfileDetailsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.GetLaunchProfileDetailsResponse
      .builder()
      .optionallyWith(launchProfile.map(value => value.buildAwsValue()))(
        _.launchProfile
      )
      .optionallyWith(
        streamingImages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.streamingImages)
      .optionallyWith(
        studioComponentSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.studioComponentSummaries)
      .build()
  }
  def asReadOnly
      : zio.aws.nimble.model.GetLaunchProfileDetailsResponse.ReadOnly =
    zio.aws.nimble.model.GetLaunchProfileDetailsResponse.wrap(buildAwsValue())
}
object GetLaunchProfileDetailsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.GetLaunchProfileDetailsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.GetLaunchProfileDetailsResponse =
      zio.aws.nimble.model.GetLaunchProfileDetailsResponse(
        launchProfile.map(value => value.asEditable),
        streamingImages.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        studioComponentSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def launchProfile: Option[zio.aws.nimble.model.LaunchProfile.ReadOnly]
    def streamingImages
        : Option[List[zio.aws.nimble.model.StreamingImage.ReadOnly]]
    def studioComponentSummaries
        : Option[List[zio.aws.nimble.model.StudioComponentSummary.ReadOnly]]
    def getLaunchProfile
        : ZIO[Any, AwsError, zio.aws.nimble.model.LaunchProfile.ReadOnly] =
      AwsError.unwrapOptionField("launchProfile", launchProfile)
    def getStreamingImages: ZIO[Any, AwsError, List[
      zio.aws.nimble.model.StreamingImage.ReadOnly
    ]] = AwsError.unwrapOptionField("streamingImages", streamingImages)
    def getStudioComponentSummaries: ZIO[Any, AwsError, List[
      zio.aws.nimble.model.StudioComponentSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "studioComponentSummaries",
      studioComponentSummaries
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.GetLaunchProfileDetailsResponse
  ) extends zio.aws.nimble.model.GetLaunchProfileDetailsResponse.ReadOnly {
    override val launchProfile
        : Option[zio.aws.nimble.model.LaunchProfile.ReadOnly] = scala
      .Option(impl.launchProfile())
      .map(value => zio.aws.nimble.model.LaunchProfile.wrap(value))
    override val streamingImages
        : Option[List[zio.aws.nimble.model.StreamingImage.ReadOnly]] = scala
      .Option(impl.streamingImages())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.nimble.model.StreamingImage.wrap(item)
        }.toList
      )
    override val studioComponentSummaries
        : Option[List[zio.aws.nimble.model.StudioComponentSummary.ReadOnly]] =
      scala
        .Option(impl.studioComponentSummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.nimble.model.StudioComponentSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.GetLaunchProfileDetailsResponse
  ): zio.aws.nimble.model.GetLaunchProfileDetailsResponse.ReadOnly =
    new Wrapper(impl)
}
