package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteStreamingSessionResponse(
    session: Option[zio.aws.nimble.model.StreamingSession] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.DeleteStreamingSessionResponse = {
    import DeleteStreamingSessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.DeleteStreamingSessionResponse
      .builder()
      .optionallyWith(session.map(value => value.buildAwsValue()))(_.session)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.DeleteStreamingSessionResponse.ReadOnly =
    zio.aws.nimble.model.DeleteStreamingSessionResponse.wrap(buildAwsValue())
}
object DeleteStreamingSessionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.DeleteStreamingSessionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.DeleteStreamingSessionResponse =
      zio.aws.nimble.model
        .DeleteStreamingSessionResponse(session.map(value => value.asEditable))
    def session: Option[zio.aws.nimble.model.StreamingSession.ReadOnly]
    def getSession
        : ZIO[Any, AwsError, zio.aws.nimble.model.StreamingSession.ReadOnly] =
      AwsError.unwrapOptionField("session", session)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.DeleteStreamingSessionResponse
  ) extends zio.aws.nimble.model.DeleteStreamingSessionResponse.ReadOnly {
    override val session
        : Option[zio.aws.nimble.model.StreamingSession.ReadOnly] = scala
      .Option(impl.session())
      .map(value => zio.aws.nimble.model.StreamingSession.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.DeleteStreamingSessionResponse
  ): zio.aws.nimble.model.DeleteStreamingSessionResponse.ReadOnly = new Wrapper(
    impl
  )
}
