package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteLaunchProfileResponse(
    launchProfile: Option[zio.aws.nimble.model.LaunchProfile] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.DeleteLaunchProfileResponse = {
    import DeleteLaunchProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.DeleteLaunchProfileResponse
      .builder()
      .optionallyWith(launchProfile.map(value => value.buildAwsValue()))(
        _.launchProfile
      )
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.DeleteLaunchProfileResponse.ReadOnly =
    zio.aws.nimble.model.DeleteLaunchProfileResponse.wrap(buildAwsValue())
}
object DeleteLaunchProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.DeleteLaunchProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.DeleteLaunchProfileResponse =
      zio.aws.nimble.model.DeleteLaunchProfileResponse(
        launchProfile.map(value => value.asEditable)
      )
    def launchProfile: Option[zio.aws.nimble.model.LaunchProfile.ReadOnly]
    def getLaunchProfile
        : ZIO[Any, AwsError, zio.aws.nimble.model.LaunchProfile.ReadOnly] =
      AwsError.unwrapOptionField("launchProfile", launchProfile)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.DeleteLaunchProfileResponse
  ) extends zio.aws.nimble.model.DeleteLaunchProfileResponse.ReadOnly {
    override val launchProfile
        : Option[zio.aws.nimble.model.LaunchProfile.ReadOnly] = scala
      .Option(impl.launchProfile())
      .map(value => zio.aws.nimble.model.LaunchProfile.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.DeleteLaunchProfileResponse
  ): zio.aws.nimble.model.DeleteLaunchProfileResponse.ReadOnly = new Wrapper(
    impl
  )
}
