package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateStudioComponentResponse(
    studioComponent: Option[zio.aws.nimble.model.StudioComponent] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.CreateStudioComponentResponse = {
    import CreateStudioComponentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.CreateStudioComponentResponse
      .builder()
      .optionallyWith(studioComponent.map(value => value.buildAwsValue()))(
        _.studioComponent
      )
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.CreateStudioComponentResponse.ReadOnly =
    zio.aws.nimble.model.CreateStudioComponentResponse.wrap(buildAwsValue())
}
object CreateStudioComponentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.CreateStudioComponentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.CreateStudioComponentResponse =
      zio.aws.nimble.model.CreateStudioComponentResponse(
        studioComponent.map(value => value.asEditable)
      )
    def studioComponent: Option[zio.aws.nimble.model.StudioComponent.ReadOnly]
    def getStudioComponent
        : ZIO[Any, AwsError, zio.aws.nimble.model.StudioComponent.ReadOnly] =
      AwsError.unwrapOptionField("studioComponent", studioComponent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.CreateStudioComponentResponse
  ) extends zio.aws.nimble.model.CreateStudioComponentResponse.ReadOnly {
    override val studioComponent
        : Option[zio.aws.nimble.model.StudioComponent.ReadOnly] = scala
      .Option(impl.studioComponent())
      .map(value => zio.aws.nimble.model.StudioComponent.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.CreateStudioComponentResponse
  ): zio.aws.nimble.model.CreateStudioComponentResponse.ReadOnly = new Wrapper(
    impl
  )
}
