package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.{
  StudioName,
  Region,
  SyntheticStudioStudioDisplayName,
  Timestamp
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Studio(
    adminRoleArn: Option[String] = None,
    arn: Option[String] = None,
    createdAt: Option[Timestamp] = None,
    displayName: Option[SyntheticStudioStudioDisplayName] = None,
    homeRegion: Option[Region] = None,
    ssoClientId: Option[String] = None,
    state: Option[zio.aws.nimble.model.StudioState] = None,
    statusCode: Option[zio.aws.nimble.model.StudioStatusCode] = None,
    statusMessage: Option[String] = None,
    studioEncryptionConfiguration: Option[
      zio.aws.nimble.model.StudioEncryptionConfiguration
    ] = None,
    studioId: Option[String] = None,
    studioName: Option[StudioName] = None,
    studioUrl: Option[String] = None,
    tags: Option[Map[String, String]] = None,
    updatedAt: Option[Timestamp] = None,
    userRoleArn: Option[String] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.nimble.model.Studio = {
    import Studio.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.Studio
      .builder()
      .optionallyWith(adminRoleArn.map(value => value: java.lang.String))(
        _.adminRoleArn
      )
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        displayName.map(value =>
          SyntheticStudioStudioDisplayName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .optionallyWith(
        homeRegion.map(value => Region.unwrap(value): java.lang.String)
      )(_.homeRegion)
      .optionallyWith(ssoClientId.map(value => value: java.lang.String))(
        _.ssoClientId
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(statusCode.map(value => value.unwrap))(_.statusCode)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(
        studioEncryptionConfiguration.map(value => value.buildAwsValue())
      )(_.studioEncryptionConfiguration)
      .optionallyWith(studioId.map(value => value: java.lang.String))(
        _.studioId
      )
      .optionallyWith(
        studioName.map(value => StudioName.unwrap(value): java.lang.String)
      )(_.studioName)
      .optionallyWith(studioUrl.map(value => value: java.lang.String))(
        _.studioUrl
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(userRoleArn.map(value => value: java.lang.String))(
        _.userRoleArn
      )
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.Studio.ReadOnly =
    zio.aws.nimble.model.Studio.wrap(buildAwsValue())
}
object Studio {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.nimble.model.Studio] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.Studio = zio.aws.nimble.model.Studio(
      adminRoleArn.map(value => value),
      arn.map(value => value),
      createdAt.map(value => value),
      displayName.map(value => value),
      homeRegion.map(value => value),
      ssoClientId.map(value => value),
      state.map(value => value),
      statusCode.map(value => value),
      statusMessage.map(value => value),
      studioEncryptionConfiguration.map(value => value.asEditable),
      studioId.map(value => value),
      studioName.map(value => value),
      studioUrl.map(value => value),
      tags.map(value => value),
      updatedAt.map(value => value),
      userRoleArn.map(value => value)
    )
    def adminRoleArn: Option[String]
    def arn: Option[String]
    def createdAt: Option[Timestamp]
    def displayName: Option[SyntheticStudioStudioDisplayName]
    def homeRegion: Option[Region]
    def ssoClientId: Option[String]
    def state: Option[zio.aws.nimble.model.StudioState]
    def statusCode: Option[zio.aws.nimble.model.StudioStatusCode]
    def statusMessage: Option[String]
    def studioEncryptionConfiguration
        : Option[zio.aws.nimble.model.StudioEncryptionConfiguration.ReadOnly]
    def studioId: Option[String]
    def studioName: Option[StudioName]
    def studioUrl: Option[String]
    def tags: Option[Map[String, String]]
    def updatedAt: Option[Timestamp]
    def userRoleArn: Option[String]
    def getAdminRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("adminRoleArn", adminRoleArn)
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDisplayName: ZIO[Any, AwsError, SyntheticStudioStudioDisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getHomeRegion: ZIO[Any, AwsError, Region] =
      AwsError.unwrapOptionField("homeRegion", homeRegion)
    def getSsoClientId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ssoClientId", ssoClientId)
    def getState: ZIO[Any, AwsError, zio.aws.nimble.model.StudioState] =
      AwsError.unwrapOptionField("state", state)
    def getStatusCode
        : ZIO[Any, AwsError, zio.aws.nimble.model.StudioStatusCode] =
      AwsError.unwrapOptionField("statusCode", statusCode)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getStudioEncryptionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.nimble.model.StudioEncryptionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "studioEncryptionConfiguration",
      studioEncryptionConfiguration
    )
    def getStudioId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("studioId", studioId)
    def getStudioName: ZIO[Any, AwsError, StudioName] =
      AwsError.unwrapOptionField("studioName", studioName)
    def getStudioUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("studioUrl", studioUrl)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getUserRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userRoleArn", userRoleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.Studio
  ) extends zio.aws.nimble.model.Studio.ReadOnly {
    override val adminRoleArn: Option[String] =
      scala.Option(impl.adminRoleArn()).map(value => value: String)
    override val arn: Option[String] =
      scala.Option(impl.arn()).map(value => value: String)
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.nimble.model.primitives.Timestamp(value))
    override val displayName: Option[SyntheticStudioStudioDisplayName] = scala
      .Option(impl.displayName())
      .map(value =>
        zio.aws.nimble.model.primitives.SyntheticStudioStudioDisplayName(value)
      )
    override val homeRegion: Option[Region] = scala
      .Option(impl.homeRegion())
      .map(value => zio.aws.nimble.model.primitives.Region(value))
    override val ssoClientId: Option[String] =
      scala.Option(impl.ssoClientId()).map(value => value: String)
    override val state: Option[zio.aws.nimble.model.StudioState] = scala
      .Option(impl.state())
      .map(value => zio.aws.nimble.model.StudioState.wrap(value))
    override val statusCode: Option[zio.aws.nimble.model.StudioStatusCode] =
      scala
        .Option(impl.statusCode())
        .map(value => zio.aws.nimble.model.StudioStatusCode.wrap(value))
    override val statusMessage: Option[String] =
      scala.Option(impl.statusMessage()).map(value => value: String)
    override val studioEncryptionConfiguration
        : Option[zio.aws.nimble.model.StudioEncryptionConfiguration.ReadOnly] =
      scala
        .Option(impl.studioEncryptionConfiguration())
        .map(value =>
          zio.aws.nimble.model.StudioEncryptionConfiguration.wrap(value)
        )
    override val studioId: Option[String] =
      scala.Option(impl.studioId()).map(value => value: String)
    override val studioName: Option[StudioName] = scala
      .Option(impl.studioName())
      .map(value => zio.aws.nimble.model.primitives.StudioName(value))
    override val studioUrl: Option[String] =
      scala.Option(impl.studioUrl()).map(value => value: String)
    override val tags: Option[Map[String, String]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val updatedAt: Option[Timestamp] = scala
      .Option(impl.updatedAt())
      .map(value => zio.aws.nimble.model.primitives.Timestamp(value))
    override val userRoleArn: Option[String] =
      scala.Option(impl.userRoleArn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.Studio
  ): zio.aws.nimble.model.Studio.ReadOnly = new Wrapper(impl)
}
