package zio.aws.nimble.model
import scala.jdk.CollectionConverters._
sealed trait StreamingImageStatusCode {
  def unwrap
      : software.amazon.awssdk.services.nimble.model.StreamingImageStatusCode
}
object StreamingImageStatusCode {
  def wrap(
      value: software.amazon.awssdk.services.nimble.model.StreamingImageStatusCode
  ): zio.aws.nimble.model.StreamingImageStatusCode = value match {
    case software.amazon.awssdk.services.nimble.model.StreamingImageStatusCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.nimble.model.StreamingImageStatusCode.STREAMING_IMAGE_CREATE_IN_PROGRESS =>
      val r = STREAMING_IMAGE_CREATE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.nimble.model.StreamingImageStatusCode.STREAMING_IMAGE_READY =>
      val r = STREAMING_IMAGE_READY
      r
    case software.amazon.awssdk.services.nimble.model.StreamingImageStatusCode.STREAMING_IMAGE_DELETE_IN_PROGRESS =>
      val r = STREAMING_IMAGE_DELETE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.nimble.model.StreamingImageStatusCode.STREAMING_IMAGE_DELETED =>
      val r = STREAMING_IMAGE_DELETED
      r
    case software.amazon.awssdk.services.nimble.model.StreamingImageStatusCode.STREAMING_IMAGE_UPDATE_IN_PROGRESS =>
      val r = STREAMING_IMAGE_UPDATE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.nimble.model.StreamingImageStatusCode.INTERNAL_ERROR =>
      val r = INTERNAL_ERROR
      r
    case software.amazon.awssdk.services.nimble.model.StreamingImageStatusCode.ACCESS_DENIED =>
      val r = ACCESS_DENIED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.nimble.model.StreamingImageStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingImageStatusCode =
      software.amazon.awssdk.services.nimble.model.StreamingImageStatusCode.UNKNOWN_TO_SDK_VERSION
  }
  case object STREAMING_IMAGE_CREATE_IN_PROGRESS
      extends zio.aws.nimble.model.StreamingImageStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingImageStatusCode =
      software.amazon.awssdk.services.nimble.model.StreamingImageStatusCode.STREAMING_IMAGE_CREATE_IN_PROGRESS
  }
  case object STREAMING_IMAGE_READY
      extends zio.aws.nimble.model.StreamingImageStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingImageStatusCode =
      software.amazon.awssdk.services.nimble.model.StreamingImageStatusCode.STREAMING_IMAGE_READY
  }
  case object STREAMING_IMAGE_DELETE_IN_PROGRESS
      extends zio.aws.nimble.model.StreamingImageStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingImageStatusCode =
      software.amazon.awssdk.services.nimble.model.StreamingImageStatusCode.STREAMING_IMAGE_DELETE_IN_PROGRESS
  }
  case object STREAMING_IMAGE_DELETED
      extends zio.aws.nimble.model.StreamingImageStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingImageStatusCode =
      software.amazon.awssdk.services.nimble.model.StreamingImageStatusCode.STREAMING_IMAGE_DELETED
  }
  case object STREAMING_IMAGE_UPDATE_IN_PROGRESS
      extends zio.aws.nimble.model.StreamingImageStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingImageStatusCode =
      software.amazon.awssdk.services.nimble.model.StreamingImageStatusCode.STREAMING_IMAGE_UPDATE_IN_PROGRESS
  }
  case object INTERNAL_ERROR
      extends zio.aws.nimble.model.StreamingImageStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingImageStatusCode =
      software.amazon.awssdk.services.nimble.model.StreamingImageStatusCode.INTERNAL_ERROR
  }
  case object ACCESS_DENIED
      extends zio.aws.nimble.model.StreamingImageStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.nimble.model.StreamingImageStatusCode =
      software.amazon.awssdk.services.nimble.model.StreamingImageStatusCode.ACCESS_DENIED
  }
}
