package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.{
  SyntheticStreamingImageStreamingImageDescription,
  StreamingImageId,
  EC2ImageId,
  StreamingImagePlatform,
  StreamingImageOwner,
  SyntheticStreamingImageStreamingImageName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StreamingImage(
    arn: Option[String] = None,
    description: Option[SyntheticStreamingImageStreamingImageDescription] =
      None,
    ec2ImageId: Option[EC2ImageId] = None,
    encryptionConfiguration: Option[
      zio.aws.nimble.model.StreamingImageEncryptionConfiguration
    ] = None,
    eulaIds: Option[Iterable[String]] = None,
    name: Option[SyntheticStreamingImageStreamingImageName] = None,
    owner: Option[StreamingImageOwner] = None,
    platform: Option[StreamingImagePlatform] = None,
    state: Option[zio.aws.nimble.model.StreamingImageState] = None,
    statusCode: Option[zio.aws.nimble.model.StreamingImageStatusCode] = None,
    statusMessage: Option[String] = None,
    streamingImageId: Option[StreamingImageId] = None,
    tags: Option[Map[String, String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.StreamingImage = {
    import StreamingImage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.StreamingImage
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(
        description.map(value =>
          SyntheticStreamingImageStreamingImageDescription.unwrap(
            value
          ): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        ec2ImageId.map(value => EC2ImageId.unwrap(value): java.lang.String)
      )(_.ec2ImageId)
      .optionallyWith(
        encryptionConfiguration.map(value => value.buildAwsValue())
      )(_.encryptionConfiguration)
      .optionallyWith(
        eulaIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.eulaIds)
      .optionallyWith(
        name.map(value =>
          SyntheticStreamingImageStreamingImageName.unwrap(
            value
          ): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        owner.map(value => StreamingImageOwner.unwrap(value): java.lang.String)
      )(_.owner)
      .optionallyWith(
        platform.map(value =>
          StreamingImagePlatform.unwrap(value): java.lang.String
        )
      )(_.platform)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(statusCode.map(value => value.unwrap))(_.statusCode)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(
        streamingImageId.map(value =>
          StreamingImageId.unwrap(value): java.lang.String
        )
      )(_.streamingImageId)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.StreamingImage.ReadOnly =
    zio.aws.nimble.model.StreamingImage.wrap(buildAwsValue())
}
object StreamingImage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.StreamingImage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.StreamingImage =
      zio.aws.nimble.model.StreamingImage(
        arn.map(value => value),
        description.map(value => value),
        ec2ImageId.map(value => value),
        encryptionConfiguration.map(value => value.asEditable),
        eulaIds.map(value => value),
        name.map(value => value),
        owner.map(value => value),
        platform.map(value => value),
        state.map(value => value),
        statusCode.map(value => value),
        statusMessage.map(value => value),
        streamingImageId.map(value => value),
        tags.map(value => value)
      )
    def arn: Option[String]
    def description: Option[SyntheticStreamingImageStreamingImageDescription]
    def ec2ImageId: Option[EC2ImageId]
    def encryptionConfiguration: Option[
      zio.aws.nimble.model.StreamingImageEncryptionConfiguration.ReadOnly
    ]
    def eulaIds: Option[List[String]]
    def name: Option[SyntheticStreamingImageStreamingImageName]
    def owner: Option[StreamingImageOwner]
    def platform: Option[StreamingImagePlatform]
    def state: Option[zio.aws.nimble.model.StreamingImageState]
    def statusCode: Option[zio.aws.nimble.model.StreamingImageStatusCode]
    def statusMessage: Option[String]
    def streamingImageId: Option[StreamingImageId]
    def tags: Option[Map[String, String]]
    def getArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("arn", arn)
    def getDescription
        : ZIO[Any, AwsError, SyntheticStreamingImageStreamingImageDescription] =
      AwsError.unwrapOptionField("description", description)
    def getEc2ImageId: ZIO[Any, AwsError, EC2ImageId] =
      AwsError.unwrapOptionField("ec2ImageId", ec2ImageId)
    def getEncryptionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.nimble.model.StreamingImageEncryptionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "encryptionConfiguration",
      encryptionConfiguration
    )
    def getEulaIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("eulaIds", eulaIds)
    def getName: ZIO[Any, AwsError, SyntheticStreamingImageStreamingImageName] =
      AwsError.unwrapOptionField("name", name)
    def getOwner: ZIO[Any, AwsError, StreamingImageOwner] =
      AwsError.unwrapOptionField("owner", owner)
    def getPlatform: ZIO[Any, AwsError, StreamingImagePlatform] =
      AwsError.unwrapOptionField("platform", platform)
    def getState: ZIO[Any, AwsError, zio.aws.nimble.model.StreamingImageState] =
      AwsError.unwrapOptionField("state", state)
    def getStatusCode
        : ZIO[Any, AwsError, zio.aws.nimble.model.StreamingImageStatusCode] =
      AwsError.unwrapOptionField("statusCode", statusCode)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getStreamingImageId: ZIO[Any, AwsError, StreamingImageId] =
      AwsError.unwrapOptionField("streamingImageId", streamingImageId)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.StreamingImage
  ) extends zio.aws.nimble.model.StreamingImage.ReadOnly {
    override val arn: Option[String] =
      scala.Option(impl.arn()).map(value => value: String)
    override val description
        : Option[SyntheticStreamingImageStreamingImageDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.nimble.model.primitives
          .SyntheticStreamingImageStreamingImageDescription(value)
      )
    override val ec2ImageId: Option[EC2ImageId] = scala
      .Option(impl.ec2ImageId())
      .map(value => zio.aws.nimble.model.primitives.EC2ImageId(value))
    override val encryptionConfiguration: Option[
      zio.aws.nimble.model.StreamingImageEncryptionConfiguration.ReadOnly
    ] = scala
      .Option(impl.encryptionConfiguration())
      .map(value =>
        zio.aws.nimble.model.StreamingImageEncryptionConfiguration.wrap(value)
      )
    override val eulaIds: Option[List[String]] = scala
      .Option(impl.eulaIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val name: Option[SyntheticStreamingImageStreamingImageName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.nimble.model.primitives
          .SyntheticStreamingImageStreamingImageName(value)
      )
    override val owner: Option[StreamingImageOwner] = scala
      .Option(impl.owner())
      .map(value => zio.aws.nimble.model.primitives.StreamingImageOwner(value))
    override val platform: Option[StreamingImagePlatform] = scala
      .Option(impl.platform())
      .map(value =>
        zio.aws.nimble.model.primitives.StreamingImagePlatform(value)
      )
    override val state: Option[zio.aws.nimble.model.StreamingImageState] = scala
      .Option(impl.state())
      .map(value => zio.aws.nimble.model.StreamingImageState.wrap(value))
    override val statusCode
        : Option[zio.aws.nimble.model.StreamingImageStatusCode] = scala
      .Option(impl.statusCode())
      .map(value => zio.aws.nimble.model.StreamingImageStatusCode.wrap(value))
    override val statusMessage: Option[String] =
      scala.Option(impl.statusMessage()).map(value => value: String)
    override val streamingImageId: Option[StreamingImageId] = scala
      .Option(impl.streamingImageId())
      .map(value => zio.aws.nimble.model.primitives.StreamingImageId(value))
    override val tags: Option[Map[String, String]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.StreamingImage
  ): zio.aws.nimble.model.StreamingImage.ReadOnly = new Wrapper(impl)
}
