package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StreamConfigurationSessionStorage(
    mode: Iterable[zio.aws.nimble.model.StreamingSessionStorageMode],
    root: Option[zio.aws.nimble.model.StreamingSessionStorageRoot] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.StreamConfigurationSessionStorage = {
    import StreamConfigurationSessionStorage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.StreamConfigurationSessionStorage
      .builder()
      .modeWithStrings(mode.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(root.map(value => value.buildAwsValue()))(_.root)
      .build()
  }
  def asReadOnly
      : zio.aws.nimble.model.StreamConfigurationSessionStorage.ReadOnly =
    zio.aws.nimble.model.StreamConfigurationSessionStorage.wrap(buildAwsValue())
}
object StreamConfigurationSessionStorage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.StreamConfigurationSessionStorage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.StreamConfigurationSessionStorage =
      zio.aws.nimble.model.StreamConfigurationSessionStorage(
        mode,
        root.map(value => value.asEditable)
      )
    def mode: List[zio.aws.nimble.model.StreamingSessionStorageMode]
    def root: Option[zio.aws.nimble.model.StreamingSessionStorageRoot.ReadOnly]
    def getMode: ZIO[Any, Nothing, List[
      zio.aws.nimble.model.StreamingSessionStorageMode
    ]] = ZIO.succeed(mode)
    def getRoot: ZIO[
      Any,
      AwsError,
      zio.aws.nimble.model.StreamingSessionStorageRoot.ReadOnly
    ] = AwsError.unwrapOptionField("root", root)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.StreamConfigurationSessionStorage
  ) extends zio.aws.nimble.model.StreamConfigurationSessionStorage.ReadOnly {
    override val mode: List[zio.aws.nimble.model.StreamingSessionStorageMode] =
      impl
        .mode()
        .asScala
        .map { item =>
          zio.aws.nimble.model.StreamingSessionStorageMode.wrap(item)
        }
        .toList
    override val root
        : Option[zio.aws.nimble.model.StreamingSessionStorageRoot.ReadOnly] =
      scala
        .Option(impl.root())
        .map(value =>
          zio.aws.nimble.model.StreamingSessionStorageRoot.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.StreamConfigurationSessionStorage
  ): zio.aws.nimble.model.StreamConfigurationSessionStorage.ReadOnly =
    new Wrapper(impl)
}
