package zio.aws.nimble.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StopStreamingSessionResponse(
    session: Option[zio.aws.nimble.model.StreamingSession] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.StopStreamingSessionResponse = {
    import StopStreamingSessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.StopStreamingSessionResponse
      .builder()
      .optionallyWith(session.map(value => value.buildAwsValue()))(_.session)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.StopStreamingSessionResponse.ReadOnly =
    zio.aws.nimble.model.StopStreamingSessionResponse.wrap(buildAwsValue())
}
object StopStreamingSessionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.StopStreamingSessionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.StopStreamingSessionResponse =
      zio.aws.nimble.model
        .StopStreamingSessionResponse(session.map(value => value.asEditable))
    def session: Option[zio.aws.nimble.model.StreamingSession.ReadOnly]
    def getSession
        : ZIO[Any, AwsError, zio.aws.nimble.model.StreamingSession.ReadOnly] =
      AwsError.unwrapOptionField("session", session)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.StopStreamingSessionResponse
  ) extends zio.aws.nimble.model.StopStreamingSessionResponse.ReadOnly {
    override val session
        : Option[zio.aws.nimble.model.StreamingSession.ReadOnly] = scala
      .Option(impl.session())
      .map(value => zio.aws.nimble.model.StreamingSession.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.StopStreamingSessionResponse
  ): zio.aws.nimble.model.StopStreamingSessionResponse.ReadOnly = new Wrapper(
    impl
  )
}
