package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.{
  WindowsMountDrive,
  LinuxMountPoint,
  SyntheticSharedFileSystemConfigurationString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SharedFileSystemConfiguration(
    endpoint: Option[SyntheticSharedFileSystemConfigurationString] = None,
    fileSystemId: Option[String] = None,
    linuxMountPoint: Option[LinuxMountPoint] = None,
    shareName: Option[SyntheticSharedFileSystemConfigurationString] = None,
    windowsMountDrive: Option[WindowsMountDrive] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.SharedFileSystemConfiguration = {
    import SharedFileSystemConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.SharedFileSystemConfiguration
      .builder()
      .optionallyWith(
        endpoint.map(value =>
          SyntheticSharedFileSystemConfigurationString.unwrap(
            value
          ): java.lang.String
        )
      )(_.endpoint)
      .optionallyWith(fileSystemId.map(value => value: java.lang.String))(
        _.fileSystemId
      )
      .optionallyWith(
        linuxMountPoint.map(value =>
          LinuxMountPoint.unwrap(value): java.lang.String
        )
      )(_.linuxMountPoint)
      .optionallyWith(
        shareName.map(value =>
          SyntheticSharedFileSystemConfigurationString.unwrap(
            value
          ): java.lang.String
        )
      )(_.shareName)
      .optionallyWith(
        windowsMountDrive.map(value =>
          WindowsMountDrive.unwrap(value): java.lang.String
        )
      )(_.windowsMountDrive)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.SharedFileSystemConfiguration.ReadOnly =
    zio.aws.nimble.model.SharedFileSystemConfiguration.wrap(buildAwsValue())
}
object SharedFileSystemConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.SharedFileSystemConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.SharedFileSystemConfiguration =
      zio.aws.nimble.model.SharedFileSystemConfiguration(
        endpoint.map(value => value),
        fileSystemId.map(value => value),
        linuxMountPoint.map(value => value),
        shareName.map(value => value),
        windowsMountDrive.map(value => value)
      )
    def endpoint: Option[SyntheticSharedFileSystemConfigurationString]
    def fileSystemId: Option[String]
    def linuxMountPoint: Option[LinuxMountPoint]
    def shareName: Option[SyntheticSharedFileSystemConfigurationString]
    def windowsMountDrive: Option[WindowsMountDrive]
    def getEndpoint
        : ZIO[Any, AwsError, SyntheticSharedFileSystemConfigurationString] =
      AwsError.unwrapOptionField("endpoint", endpoint)
    def getFileSystemId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("fileSystemId", fileSystemId)
    def getLinuxMountPoint: ZIO[Any, AwsError, LinuxMountPoint] =
      AwsError.unwrapOptionField("linuxMountPoint", linuxMountPoint)
    def getShareName
        : ZIO[Any, AwsError, SyntheticSharedFileSystemConfigurationString] =
      AwsError.unwrapOptionField("shareName", shareName)
    def getWindowsMountDrive: ZIO[Any, AwsError, WindowsMountDrive] =
      AwsError.unwrapOptionField("windowsMountDrive", windowsMountDrive)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.SharedFileSystemConfiguration
  ) extends zio.aws.nimble.model.SharedFileSystemConfiguration.ReadOnly {
    override val endpoint
        : Option[SyntheticSharedFileSystemConfigurationString] = scala
      .Option(impl.endpoint())
      .map(value =>
        zio.aws.nimble.model.primitives
          .SyntheticSharedFileSystemConfigurationString(value)
      )
    override val fileSystemId: Option[String] =
      scala.Option(impl.fileSystemId()).map(value => value: String)
    override val linuxMountPoint: Option[LinuxMountPoint] = scala
      .Option(impl.linuxMountPoint())
      .map(value => zio.aws.nimble.model.primitives.LinuxMountPoint(value))
    override val shareName
        : Option[SyntheticSharedFileSystemConfigurationString] = scala
      .Option(impl.shareName())
      .map(value =>
        zio.aws.nimble.model.primitives
          .SyntheticSharedFileSystemConfigurationString(value)
      )
    override val windowsMountDrive: Option[WindowsMountDrive] = scala
      .Option(impl.windowsMountDrive())
      .map(value => zio.aws.nimble.model.primitives.WindowsMountDrive(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.SharedFileSystemConfiguration
  ): zio.aws.nimble.model.SharedFileSystemConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
