package zio.aws.nimble.model
import java.lang.Integer
import zio.aws.nimble.model.primitives.MaxResults
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListStudioComponentsRequest(
    maxResults: Option[MaxResults] = None,
    nextToken: Option[String] = None,
    states: Option[Iterable[String]] = None,
    studioId: String,
    types: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.ListStudioComponentsRequest = {
    import ListStudioComponentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.ListStudioComponentsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        states.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.states)
      .studioId(studioId: java.lang.String)
      .optionallyWith(
        types.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.types)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.ListStudioComponentsRequest.ReadOnly =
    zio.aws.nimble.model.ListStudioComponentsRequest.wrap(buildAwsValue())
}
object ListStudioComponentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.ListStudioComponentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.ListStudioComponentsRequest =
      zio.aws.nimble.model.ListStudioComponentsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        states.map(value => value),
        studioId,
        types.map(value => value)
      )
    def maxResults: Option[MaxResults]
    def nextToken: Option[String]
    def states: Option[List[String]]
    def studioId: String
    def types: Option[List[String]]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getStates: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("states", states)
    def getStudioId: ZIO[Any, Nothing, String] = ZIO.succeed(studioId)
    def getTypes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("types", types)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.ListStudioComponentsRequest
  ) extends zio.aws.nimble.model.ListStudioComponentsRequest.ReadOnly {
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.nimble.model.primitives.MaxResults(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val states: Option[List[String]] = scala
      .Option(impl.states())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val studioId: String = impl.studioId(): String
    override val types: Option[List[String]] = scala
      .Option(impl.types())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.ListStudioComponentsRequest
  ): zio.aws.nimble.model.ListStudioComponentsRequest.ReadOnly = new Wrapper(
    impl
  )
}
