package zio.aws.nimble.model
import java.lang.Integer
import zio.aws.nimble.model.primitives.MaxResults
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListLaunchProfilesRequest(
    maxResults: Option[MaxResults] = None,
    nextToken: Option[String] = None,
    principalId: Option[String] = None,
    states: Option[Iterable[String]] = None,
    studioId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.ListLaunchProfilesRequest = {
    import ListLaunchProfilesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.ListLaunchProfilesRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(principalId.map(value => value: java.lang.String))(
        _.principalId
      )
      .optionallyWith(
        states.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.states)
      .studioId(studioId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.ListLaunchProfilesRequest.ReadOnly =
    zio.aws.nimble.model.ListLaunchProfilesRequest.wrap(buildAwsValue())
}
object ListLaunchProfilesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.ListLaunchProfilesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.ListLaunchProfilesRequest =
      zio.aws.nimble.model.ListLaunchProfilesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        principalId.map(value => value),
        states.map(value => value),
        studioId
      )
    def maxResults: Option[MaxResults]
    def nextToken: Option[String]
    def principalId: Option[String]
    def states: Option[List[String]]
    def studioId: String
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPrincipalId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("principalId", principalId)
    def getStates: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("states", states)
    def getStudioId: ZIO[Any, Nothing, String] = ZIO.succeed(studioId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.ListLaunchProfilesRequest
  ) extends zio.aws.nimble.model.ListLaunchProfilesRequest.ReadOnly {
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.nimble.model.primitives.MaxResults(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val principalId: Option[String] =
      scala.Option(impl.principalId()).map(value => value: String)
    override val states: Option[List[String]] = scala
      .Option(impl.states())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val studioId: String = impl.studioId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.ListLaunchProfilesRequest
  ): zio.aws.nimble.model.ListLaunchProfilesRequest.ReadOnly = new Wrapper(impl)
}
