package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.{EulaId, EulaAcceptanceId, Timestamp}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class EulaAcceptance(
    acceptedAt: Option[Timestamp] = None,
    acceptedBy: Option[String] = None,
    accepteeId: Option[String] = None,
    eulaAcceptanceId: Option[EulaAcceptanceId] = None,
    eulaId: Option[EulaId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.EulaAcceptance = {
    import EulaAcceptance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.EulaAcceptance
      .builder()
      .optionallyWith(
        acceptedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.acceptedAt)
      .optionallyWith(acceptedBy.map(value => value: java.lang.String))(
        _.acceptedBy
      )
      .optionallyWith(accepteeId.map(value => value: java.lang.String))(
        _.accepteeId
      )
      .optionallyWith(
        eulaAcceptanceId.map(value =>
          EulaAcceptanceId.unwrap(value): java.lang.String
        )
      )(_.eulaAcceptanceId)
      .optionallyWith(
        eulaId.map(value => EulaId.unwrap(value): java.lang.String)
      )(_.eulaId)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.EulaAcceptance.ReadOnly =
    zio.aws.nimble.model.EulaAcceptance.wrap(buildAwsValue())
}
object EulaAcceptance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.EulaAcceptance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.EulaAcceptance =
      zio.aws.nimble.model.EulaAcceptance(
        acceptedAt.map(value => value),
        acceptedBy.map(value => value),
        accepteeId.map(value => value),
        eulaAcceptanceId.map(value => value),
        eulaId.map(value => value)
      )
    def acceptedAt: Option[Timestamp]
    def acceptedBy: Option[String]
    def accepteeId: Option[String]
    def eulaAcceptanceId: Option[EulaAcceptanceId]
    def eulaId: Option[EulaId]
    def getAcceptedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("acceptedAt", acceptedAt)
    def getAcceptedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("acceptedBy", acceptedBy)
    def getAccepteeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("accepteeId", accepteeId)
    def getEulaAcceptanceId: ZIO[Any, AwsError, EulaAcceptanceId] =
      AwsError.unwrapOptionField("eulaAcceptanceId", eulaAcceptanceId)
    def getEulaId: ZIO[Any, AwsError, EulaId] =
      AwsError.unwrapOptionField("eulaId", eulaId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.EulaAcceptance
  ) extends zio.aws.nimble.model.EulaAcceptance.ReadOnly {
    override val acceptedAt: Option[Timestamp] = scala
      .Option(impl.acceptedAt())
      .map(value => zio.aws.nimble.model.primitives.Timestamp(value))
    override val acceptedBy: Option[String] =
      scala.Option(impl.acceptedBy()).map(value => value: String)
    override val accepteeId: Option[String] =
      scala.Option(impl.accepteeId()).map(value => value: String)
    override val eulaAcceptanceId: Option[EulaAcceptanceId] = scala
      .Option(impl.eulaAcceptanceId())
      .map(value => zio.aws.nimble.model.primitives.EulaAcceptanceId(value))
    override val eulaId: Option[EulaId] = scala
      .Option(impl.eulaId())
      .map(value => zio.aws.nimble.model.primitives.EulaId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.EulaAcceptance
  ): zio.aws.nimble.model.EulaAcceptance.ReadOnly = new Wrapper(impl)
}
