package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.ClientToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteLaunchProfileMemberRequest(
    clientToken: Option[ClientToken] = None,
    launchProfileId: String,
    principalId: String,
    studioId: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.DeleteLaunchProfileMemberRequest = {
    import DeleteLaunchProfileMemberRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.DeleteLaunchProfileMemberRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .launchProfileId(launchProfileId: java.lang.String)
      .principalId(principalId: java.lang.String)
      .studioId(studioId: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.nimble.model.DeleteLaunchProfileMemberRequest.ReadOnly =
    zio.aws.nimble.model.DeleteLaunchProfileMemberRequest.wrap(buildAwsValue())
}
object DeleteLaunchProfileMemberRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.DeleteLaunchProfileMemberRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.DeleteLaunchProfileMemberRequest =
      zio.aws.nimble.model.DeleteLaunchProfileMemberRequest(
        clientToken.map(value => value),
        launchProfileId,
        principalId,
        studioId
      )
    def clientToken: Option[ClientToken]
    def launchProfileId: String
    def principalId: String
    def studioId: String
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getLaunchProfileId: ZIO[Any, Nothing, String] =
      ZIO.succeed(launchProfileId)
    def getPrincipalId: ZIO[Any, Nothing, String] = ZIO.succeed(principalId)
    def getStudioId: ZIO[Any, Nothing, String] = ZIO.succeed(studioId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.DeleteLaunchProfileMemberRequest
  ) extends zio.aws.nimble.model.DeleteLaunchProfileMemberRequest.ReadOnly {
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.nimble.model.primitives.ClientToken(value))
    override val launchProfileId: String = impl.launchProfileId(): String
    override val principalId: String = impl.principalId(): String
    override val studioId: String = impl.studioId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.DeleteLaunchProfileMemberRequest
  ): zio.aws.nimble.model.DeleteLaunchProfileMemberRequest.ReadOnly =
    new Wrapper(impl)
}
