package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.{
  StudioName,
  SyntheticCreateStudioRequestStudioDisplayName,
  ClientToken
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateStudioRequest(
    adminRoleArn: String,
    clientToken: Option[ClientToken] = None,
    displayName: SyntheticCreateStudioRequestStudioDisplayName,
    studioEncryptionConfiguration: Option[
      zio.aws.nimble.model.StudioEncryptionConfiguration
    ] = None,
    studioName: StudioName,
    tags: Option[Map[String, String]] = None,
    userRoleArn: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.CreateStudioRequest = {
    import CreateStudioRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.CreateStudioRequest
      .builder()
      .adminRoleArn(adminRoleArn: java.lang.String)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .displayName(
        SyntheticCreateStudioRequestStudioDisplayName.unwrap(
          displayName
        ): java.lang.String
      )
      .optionallyWith(
        studioEncryptionConfiguration.map(value => value.buildAwsValue())
      )(_.studioEncryptionConfiguration)
      .studioName(StudioName.unwrap(studioName): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .userRoleArn(userRoleArn: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.CreateStudioRequest.ReadOnly =
    zio.aws.nimble.model.CreateStudioRequest.wrap(buildAwsValue())
}
object CreateStudioRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.CreateStudioRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.CreateStudioRequest =
      zio.aws.nimble.model.CreateStudioRequest(
        adminRoleArn,
        clientToken.map(value => value),
        displayName,
        studioEncryptionConfiguration.map(value => value.asEditable),
        studioName,
        tags.map(value => value),
        userRoleArn
      )
    def adminRoleArn: String
    def clientToken: Option[ClientToken]
    def displayName: SyntheticCreateStudioRequestStudioDisplayName
    def studioEncryptionConfiguration
        : Option[zio.aws.nimble.model.StudioEncryptionConfiguration.ReadOnly]
    def studioName: StudioName
    def tags: Option[Map[String, String]]
    def userRoleArn: String
    def getAdminRoleArn: ZIO[Any, Nothing, String] = ZIO.succeed(adminRoleArn)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDisplayName
        : ZIO[Any, Nothing, SyntheticCreateStudioRequestStudioDisplayName] =
      ZIO.succeed(displayName)
    def getStudioEncryptionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.nimble.model.StudioEncryptionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "studioEncryptionConfiguration",
      studioEncryptionConfiguration
    )
    def getStudioName: ZIO[Any, Nothing, StudioName] = ZIO.succeed(studioName)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
    def getUserRoleArn: ZIO[Any, Nothing, String] = ZIO.succeed(userRoleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.CreateStudioRequest
  ) extends zio.aws.nimble.model.CreateStudioRequest.ReadOnly {
    override val adminRoleArn: String = impl.adminRoleArn(): String
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.nimble.model.primitives.ClientToken(value))
    override val displayName: SyntheticCreateStudioRequestStudioDisplayName =
      zio.aws.nimble.model.primitives
        .SyntheticCreateStudioRequestStudioDisplayName(impl.displayName())
    override val studioEncryptionConfiguration
        : Option[zio.aws.nimble.model.StudioEncryptionConfiguration.ReadOnly] =
      scala
        .Option(impl.studioEncryptionConfiguration())
        .map(value =>
          zio.aws.nimble.model.StudioEncryptionConfiguration.wrap(value)
        )
    override val studioName: StudioName =
      zio.aws.nimble.model.primitives.StudioName(impl.studioName())
    override val tags: Option[Map[String, String]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val userRoleArn: String = impl.userRoleArn(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.CreateStudioRequest
  ): zio.aws.nimble.model.CreateStudioRequest.ReadOnly = new Wrapper(impl)
}
