package zio.aws.nimble.model
import zio.aws.nimble.model.primitives.{
  SyntheticCreateStreamingImageRequestStreamingImageName,
  EC2ImageId,
  SyntheticCreateStreamingImageRequestStreamingImageDescription,
  ClientToken
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateStreamingImageRequest(
    clientToken: Option[ClientToken] = None,
    description: Option[
      SyntheticCreateStreamingImageRequestStreamingImageDescription
    ] = None,
    ec2ImageId: EC2ImageId,
    name: SyntheticCreateStreamingImageRequestStreamingImageName,
    studioId: String,
    tags: Option[Map[String, String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.nimble.model.CreateStreamingImageRequest = {
    import CreateStreamingImageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.nimble.model.CreateStreamingImageRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        description.map(value =>
          SyntheticCreateStreamingImageRequestStreamingImageDescription.unwrap(
            value
          ): java.lang.String
        )
      )(_.description)
      .ec2ImageId(EC2ImageId.unwrap(ec2ImageId): java.lang.String)
      .name(
        SyntheticCreateStreamingImageRequestStreamingImageName.unwrap(
          name
        ): java.lang.String
      )
      .studioId(studioId: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.nimble.model.CreateStreamingImageRequest.ReadOnly =
    zio.aws.nimble.model.CreateStreamingImageRequest.wrap(buildAwsValue())
}
object CreateStreamingImageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.nimble.model.CreateStreamingImageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.nimble.model.CreateStreamingImageRequest =
      zio.aws.nimble.model.CreateStreamingImageRequest(
        clientToken.map(value => value),
        description.map(value => value),
        ec2ImageId,
        name,
        studioId,
        tags.map(value => value)
      )
    def clientToken: Option[ClientToken]
    def description
        : Option[SyntheticCreateStreamingImageRequestStreamingImageDescription]
    def ec2ImageId: EC2ImageId
    def name: SyntheticCreateStreamingImageRequestStreamingImageName
    def studioId: String
    def tags: Option[Map[String, String]]
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDescription: ZIO[
      Any,
      AwsError,
      SyntheticCreateStreamingImageRequestStreamingImageDescription
    ] = AwsError.unwrapOptionField("description", description)
    def getEc2ImageId: ZIO[Any, Nothing, EC2ImageId] = ZIO.succeed(ec2ImageId)
    def getName: ZIO[
      Any,
      Nothing,
      SyntheticCreateStreamingImageRequestStreamingImageName
    ] = ZIO.succeed(name)
    def getStudioId: ZIO[Any, Nothing, String] = ZIO.succeed(studioId)
    def getTags: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.nimble.model.CreateStreamingImageRequest
  ) extends zio.aws.nimble.model.CreateStreamingImageRequest.ReadOnly {
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.nimble.model.primitives.ClientToken(value))
    override val description: Option[
      SyntheticCreateStreamingImageRequestStreamingImageDescription
    ] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.nimble.model.primitives
          .SyntheticCreateStreamingImageRequestStreamingImageDescription(value)
      )
    override val ec2ImageId: EC2ImageId =
      zio.aws.nimble.model.primitives.EC2ImageId(impl.ec2ImageId())
    override val name: SyntheticCreateStreamingImageRequestStreamingImageName =
      zio.aws.nimble.model.primitives
        .SyntheticCreateStreamingImageRequestStreamingImageName(impl.name())
    override val studioId: String = impl.studioId(): String
    override val tags: Option[Map[String, String]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.nimble.model.CreateStreamingImageRequest
  ): zio.aws.nimble.model.CreateStreamingImageRequest.ReadOnly = new Wrapper(
    impl
  )
}
