package zio.aws.networkmanager.model
import scala.jdk.CollectionConverters.*
sealed trait TunnelProtocol {
  def unwrap
      : software.amazon.awssdk.services.networkmanager.model.TunnelProtocol
}
object TunnelProtocol {
  def wrap(
      value: software.amazon.awssdk.services.networkmanager.model.TunnelProtocol
  ): zio.aws.networkmanager.model.TunnelProtocol = value match {
    case software.amazon.awssdk.services.networkmanager.model.TunnelProtocol.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.networkmanager.model.TunnelProtocol.GRE =>
      val r = GRE
      r
    case software.amazon.awssdk.services.networkmanager.model.TunnelProtocol.NO_ENCAP =>
      val r = NO_ENCAP
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.networkmanager.model.TunnelProtocol {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.TunnelProtocol =
      software.amazon.awssdk.services.networkmanager.model.TunnelProtocol.UNKNOWN_TO_SDK_VERSION
  }
  case object GRE extends zio.aws.networkmanager.model.TunnelProtocol {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.TunnelProtocol =
      software.amazon.awssdk.services.networkmanager.model.TunnelProtocol.GRE
  }
  case object NO_ENCAP extends zio.aws.networkmanager.model.TunnelProtocol {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.TunnelProtocol =
      software.amazon.awssdk.services.networkmanager.model.TunnelProtocol.NO_ENCAP
  }
}
