package zio.aws.networkmanager.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkmanager.model.primitives.{
  NextToken,
  MaxResults,
  ExternalRegionCode,
  CoreNetworkId
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListAttachmentsRequest(
    coreNetworkId: Optional[CoreNetworkId] = Optional.Absent,
    attachmentType: Optional[zio.aws.networkmanager.model.AttachmentType] =
      Optional.Absent,
    edgeLocation: Optional[ExternalRegionCode] = Optional.Absent,
    state: Optional[zio.aws.networkmanager.model.AttachmentState] =
      Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.ListAttachmentsRequest = {
    import ListAttachmentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.ListAttachmentsRequest
      .builder()
      .optionallyWith(
        coreNetworkId.map(value =>
          CoreNetworkId.unwrap(value): java.lang.String
        )
      )(_.coreNetworkId)
      .optionallyWith(attachmentType.map(value => value.unwrap))(
        _.attachmentType
      )
      .optionallyWith(
        edgeLocation.map(value =>
          ExternalRegionCode.unwrap(value): java.lang.String
        )
      )(_.edgeLocation)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.ListAttachmentsRequest.ReadOnly =
    zio.aws.networkmanager.model.ListAttachmentsRequest.wrap(buildAwsValue())
}
object ListAttachmentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.ListAttachmentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.ListAttachmentsRequest =
      zio.aws.networkmanager.model.ListAttachmentsRequest(
        coreNetworkId.map(value => value),
        attachmentType.map(value => value),
        edgeLocation.map(value => value),
        state.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def coreNetworkId: Optional[CoreNetworkId]
    def attachmentType: Optional[zio.aws.networkmanager.model.AttachmentType]
    def edgeLocation: Optional[ExternalRegionCode]
    def state: Optional[zio.aws.networkmanager.model.AttachmentState]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getCoreNetworkId: ZIO[Any, AwsError, CoreNetworkId] =
      AwsError.unwrapOptionField("coreNetworkId", coreNetworkId)
    def getAttachmentType
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.AttachmentType] =
      AwsError.unwrapOptionField("attachmentType", attachmentType)
    def getEdgeLocation: ZIO[Any, AwsError, ExternalRegionCode] =
      AwsError.unwrapOptionField("edgeLocation", edgeLocation)
    def getState
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.AttachmentState] =
      AwsError.unwrapOptionField("state", state)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.ListAttachmentsRequest
  ) extends zio.aws.networkmanager.model.ListAttachmentsRequest.ReadOnly {
    override val coreNetworkId: Optional[CoreNetworkId] = zio.aws.core.internal
      .optionalFromNullable(impl.coreNetworkId())
      .map(value =>
        zio.aws.networkmanager.model.primitives.CoreNetworkId(value)
      )
    override val attachmentType
        : Optional[zio.aws.networkmanager.model.AttachmentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attachmentType())
        .map(value => zio.aws.networkmanager.model.AttachmentType.wrap(value))
    override val edgeLocation: Optional[ExternalRegionCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.edgeLocation())
        .map(value =>
          zio.aws.networkmanager.model.primitives.ExternalRegionCode(value)
        )
    override val state: Optional[zio.aws.networkmanager.model.AttachmentState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.networkmanager.model.AttachmentState.wrap(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.networkmanager.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.networkmanager.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.ListAttachmentsRequest
  ): zio.aws.networkmanager.model.ListAttachmentsRequest.ReadOnly = new Wrapper(
    impl
  )
}
