package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteConnectionResponse(
    connection: Optional[zio.aws.networkmanager.model.Connection] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.DeleteConnectionResponse = {
    import DeleteConnectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.DeleteConnectionResponse
      .builder()
      .optionallyWith(connection.map(value => value.buildAwsValue()))(
        _.connection
      )
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.DeleteConnectionResponse.ReadOnly =
    zio.aws.networkmanager.model.DeleteConnectionResponse.wrap(buildAwsValue())
}
object DeleteConnectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.DeleteConnectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.DeleteConnectionResponse =
      zio.aws.networkmanager.model
        .DeleteConnectionResponse(connection.map(value => value.asEditable))
    def connection: Optional[zio.aws.networkmanager.model.Connection.ReadOnly]
    def getConnection
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.Connection.ReadOnly] =
      AwsError.unwrapOptionField("connection", connection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.DeleteConnectionResponse
  ) extends zio.aws.networkmanager.model.DeleteConnectionResponse.ReadOnly {
    override val connection
        : Optional[zio.aws.networkmanager.model.Connection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connection())
        .map(value => zio.aws.networkmanager.model.Connection.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.DeleteConnectionResponse
  ): zio.aws.networkmanager.model.DeleteConnectionResponse.ReadOnly =
    new Wrapper(impl)
}
