package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateSiteResponse(
    site: Optional[zio.aws.networkmanager.model.Site] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.UpdateSiteResponse = {
    import UpdateSiteResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.UpdateSiteResponse
      .builder()
      .optionallyWith(site.map(value => value.buildAwsValue()))(_.site)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.UpdateSiteResponse.ReadOnly =
    zio.aws.networkmanager.model.UpdateSiteResponse.wrap(buildAwsValue())
}
object UpdateSiteResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.UpdateSiteResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.UpdateSiteResponse =
      zio.aws.networkmanager.model
        .UpdateSiteResponse(site.map(value => value.asEditable))
    def site: Optional[zio.aws.networkmanager.model.Site.ReadOnly]
    def getSite
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.Site.ReadOnly] =
      AwsError.unwrapOptionField("site", site)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.UpdateSiteResponse
  ) extends zio.aws.networkmanager.model.UpdateSiteResponse.ReadOnly {
    override val site: Optional[zio.aws.networkmanager.model.Site.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.site())
        .map(value => zio.aws.networkmanager.model.Site.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.UpdateSiteResponse
  ): zio.aws.networkmanager.model.UpdateSiteResponse.ReadOnly = new Wrapper(
    impl
  )
}
