package zio.aws.networkmanager.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkmanager.model.primitives.{
  ConstrainedString,
  GlobalNetworkId,
  DateTime,
  CoreNetworkArn,
  CoreNetworkId
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class CoreNetwork(
    globalNetworkId: Optional[GlobalNetworkId] = Optional.Absent,
    coreNetworkId: Optional[CoreNetworkId] = Optional.Absent,
    coreNetworkArn: Optional[CoreNetworkArn] = Optional.Absent,
    description: Optional[ConstrainedString] = Optional.Absent,
    createdAt: Optional[DateTime] = Optional.Absent,
    state: Optional[zio.aws.networkmanager.model.CoreNetworkState] =
      Optional.Absent,
    segments: Optional[
      Iterable[zio.aws.networkmanager.model.CoreNetworkSegment]
    ] = Optional.Absent,
    edges: Optional[Iterable[zio.aws.networkmanager.model.CoreNetworkEdge]] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.networkmanager.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.CoreNetwork = {
    import CoreNetwork.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.CoreNetwork
      .builder()
      .optionallyWith(
        globalNetworkId.map(value =>
          GlobalNetworkId.unwrap(value): java.lang.String
        )
      )(_.globalNetworkId)
      .optionallyWith(
        coreNetworkId.map(value =>
          CoreNetworkId.unwrap(value): java.lang.String
        )
      )(_.coreNetworkId)
      .optionallyWith(
        coreNetworkArn.map(value =>
          CoreNetworkArn.unwrap(value): java.lang.String
        )
      )(_.coreNetworkArn)
      .optionallyWith(
        description.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(createdAt.map(value => DateTime.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        segments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.segments)
      .optionallyWith(
        edges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.edges)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.CoreNetwork.ReadOnly =
    zio.aws.networkmanager.model.CoreNetwork.wrap(buildAwsValue())
}
object CoreNetwork {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.CoreNetwork
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.CoreNetwork =
      zio.aws.networkmanager.model.CoreNetwork(
        globalNetworkId.map(value => value),
        coreNetworkId.map(value => value),
        coreNetworkArn.map(value => value),
        description.map(value => value),
        createdAt.map(value => value),
        state.map(value => value),
        segments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        edges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def globalNetworkId: Optional[GlobalNetworkId]
    def coreNetworkId: Optional[CoreNetworkId]
    def coreNetworkArn: Optional[CoreNetworkArn]
    def description: Optional[ConstrainedString]
    def createdAt: Optional[DateTime]
    def state: Optional[zio.aws.networkmanager.model.CoreNetworkState]
    def segments: Optional[
      List[zio.aws.networkmanager.model.CoreNetworkSegment.ReadOnly]
    ]
    def edges
        : Optional[List[zio.aws.networkmanager.model.CoreNetworkEdge.ReadOnly]]
    def tags: Optional[List[zio.aws.networkmanager.model.Tag.ReadOnly]]
    def getGlobalNetworkId: ZIO[Any, AwsError, GlobalNetworkId] =
      AwsError.unwrapOptionField("globalNetworkId", globalNetworkId)
    def getCoreNetworkId: ZIO[Any, AwsError, CoreNetworkId] =
      AwsError.unwrapOptionField("coreNetworkId", coreNetworkId)
    def getCoreNetworkArn: ZIO[Any, AwsError, CoreNetworkArn] =
      AwsError.unwrapOptionField("coreNetworkArn", coreNetworkArn)
    def getDescription: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("description", description)
    def getCreatedAt: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getState
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.CoreNetworkState] =
      AwsError.unwrapOptionField("state", state)
    def getSegments: ZIO[Any, AwsError, List[
      zio.aws.networkmanager.model.CoreNetworkSegment.ReadOnly
    ]] = AwsError.unwrapOptionField("segments", segments)
    def getEdges: ZIO[Any, AwsError, List[
      zio.aws.networkmanager.model.CoreNetworkEdge.ReadOnly
    ]] = AwsError.unwrapOptionField("edges", edges)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.CoreNetwork
  ) extends zio.aws.networkmanager.model.CoreNetwork.ReadOnly {
    override val globalNetworkId: Optional[GlobalNetworkId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalNetworkId())
        .map(value =>
          zio.aws.networkmanager.model.primitives.GlobalNetworkId(value)
        )
    override val coreNetworkId: Optional[CoreNetworkId] = zio.aws.core.internal
      .optionalFromNullable(impl.coreNetworkId())
      .map(value =>
        zio.aws.networkmanager.model.primitives.CoreNetworkId(value)
      )
    override val coreNetworkArn: Optional[CoreNetworkArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.coreNetworkArn())
        .map(value =>
          zio.aws.networkmanager.model.primitives.CoreNetworkArn(value)
        )
    override val description: Optional[ConstrainedString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.networkmanager.model.primitives.ConstrainedString(value)
        )
    override val createdAt: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.networkmanager.model.primitives.DateTime(value))
    override val state
        : Optional[zio.aws.networkmanager.model.CoreNetworkState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.networkmanager.model.CoreNetworkState.wrap(value))
    override val segments: Optional[
      List[zio.aws.networkmanager.model.CoreNetworkSegment.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.segments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkmanager.model.CoreNetworkSegment.wrap(item)
        }.toList
      )
    override val edges: Optional[
      List[zio.aws.networkmanager.model.CoreNetworkEdge.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.edges())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkmanager.model.CoreNetworkEdge.wrap(item)
        }.toList
      )
    override val tags
        : Optional[List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.CoreNetwork
  ): zio.aws.networkmanager.model.CoreNetwork.ReadOnly = new Wrapper(impl)
}
