package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AssociateTransitGatewayConnectPeerResponse(
    transitGatewayConnectPeerAssociation: Optional[
      zio.aws.networkmanager.model.TransitGatewayConnectPeerAssociation
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.AssociateTransitGatewayConnectPeerResponse = {
    import AssociateTransitGatewayConnectPeerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.AssociateTransitGatewayConnectPeerResponse
      .builder()
      .optionallyWith(
        transitGatewayConnectPeerAssociation.map(value => value.buildAwsValue())
      )(_.transitGatewayConnectPeerAssociation)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.AssociateTransitGatewayConnectPeerResponse.ReadOnly =
    zio.aws.networkmanager.model.AssociateTransitGatewayConnectPeerResponse
      .wrap(buildAwsValue())
}
object AssociateTransitGatewayConnectPeerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.AssociateTransitGatewayConnectPeerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.AssociateTransitGatewayConnectPeerResponse =
      zio.aws.networkmanager.model.AssociateTransitGatewayConnectPeerResponse(
        transitGatewayConnectPeerAssociation.map(value => value.asEditable)
      )
    def transitGatewayConnectPeerAssociation: Optional[
      zio.aws.networkmanager.model.TransitGatewayConnectPeerAssociation.ReadOnly
    ]
    def getTransitGatewayConnectPeerAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.TransitGatewayConnectPeerAssociation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "transitGatewayConnectPeerAssociation",
      transitGatewayConnectPeerAssociation
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.AssociateTransitGatewayConnectPeerResponse
  ) extends zio.aws.networkmanager.model.AssociateTransitGatewayConnectPeerResponse.ReadOnly {
    override val transitGatewayConnectPeerAssociation: Optional[
      zio.aws.networkmanager.model.TransitGatewayConnectPeerAssociation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayConnectPeerAssociation())
      .map(value =>
        zio.aws.networkmanager.model.TransitGatewayConnectPeerAssociation
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.AssociateTransitGatewayConnectPeerResponse
  ): zio.aws.networkmanager.model.AssociateTransitGatewayConnectPeerResponse.ReadOnly =
    new Wrapper(impl)
}
