package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetNetworkTelemetryResponse(
    networkTelemetry: Optional[
      Iterable[zio.aws.networkmanager.model.NetworkTelemetry]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.GetNetworkTelemetryResponse = {
    import GetNetworkTelemetryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.GetNetworkTelemetryResponse
      .builder()
      .optionallyWith(
        networkTelemetry.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkTelemetry)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.GetNetworkTelemetryResponse.ReadOnly =
    zio.aws.networkmanager.model.GetNetworkTelemetryResponse
      .wrap(buildAwsValue())
}
object GetNetworkTelemetryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.GetNetworkTelemetryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.GetNetworkTelemetryResponse =
      zio.aws.networkmanager.model.GetNetworkTelemetryResponse(
        networkTelemetry.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def networkTelemetry
        : Optional[List[zio.aws.networkmanager.model.NetworkTelemetry.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getNetworkTelemetry: ZIO[Any, AwsError, List[
      zio.aws.networkmanager.model.NetworkTelemetry.ReadOnly
    ]] = AwsError.unwrapOptionField("networkTelemetry", networkTelemetry)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.GetNetworkTelemetryResponse
  ) extends zio.aws.networkmanager.model.GetNetworkTelemetryResponse.ReadOnly {
    override val networkTelemetry: Optional[
      List[zio.aws.networkmanager.model.NetworkTelemetry.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.networkTelemetry())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkmanager.model.NetworkTelemetry.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.networkmanager.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.GetNetworkTelemetryResponse
  ): zio.aws.networkmanager.model.GetNetworkTelemetryResponse.ReadOnly =
    new Wrapper(impl)
}
