package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetLinkAssociationsResponse(
    linkAssociations: Optional[
      Iterable[zio.aws.networkmanager.model.LinkAssociation]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.GetLinkAssociationsResponse = {
    import GetLinkAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.GetLinkAssociationsResponse
      .builder()
      .optionallyWith(
        linkAssociations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.linkAssociations)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.GetLinkAssociationsResponse.ReadOnly =
    zio.aws.networkmanager.model.GetLinkAssociationsResponse
      .wrap(buildAwsValue())
}
object GetLinkAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.GetLinkAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.GetLinkAssociationsResponse =
      zio.aws.networkmanager.model.GetLinkAssociationsResponse(
        linkAssociations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def linkAssociations
        : Optional[List[zio.aws.networkmanager.model.LinkAssociation.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getLinkAssociations: ZIO[Any, AwsError, List[
      zio.aws.networkmanager.model.LinkAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField("linkAssociations", linkAssociations)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.GetLinkAssociationsResponse
  ) extends zio.aws.networkmanager.model.GetLinkAssociationsResponse.ReadOnly {
    override val linkAssociations: Optional[
      List[zio.aws.networkmanager.model.LinkAssociation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.linkAssociations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkmanager.model.LinkAssociation.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.networkmanager.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.GetLinkAssociationsResponse
  ): zio.aws.networkmanager.model.GetLinkAssociationsResponse.ReadOnly =
    new Wrapper(impl)
}
