package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetDevicesResponse(
    devices: Optional[Iterable[zio.aws.networkmanager.model.Device]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.GetDevicesResponse = {
    import GetDevicesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.GetDevicesResponse
      .builder()
      .optionallyWith(
        devices.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.devices)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.GetDevicesResponse.ReadOnly =
    zio.aws.networkmanager.model.GetDevicesResponse.wrap(buildAwsValue())
}
object GetDevicesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.GetDevicesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.GetDevicesResponse =
      zio.aws.networkmanager.model.GetDevicesResponse(
        devices.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def devices: Optional[List[zio.aws.networkmanager.model.Device.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getDevices: ZIO[Any, AwsError, List[
      zio.aws.networkmanager.model.Device.ReadOnly
    ]] = AwsError.unwrapOptionField("devices", devices)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.GetDevicesResponse
  ) extends zio.aws.networkmanager.model.GetDevicesResponse.ReadOnly {
    override val devices
        : Optional[List[zio.aws.networkmanager.model.Device.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.devices())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.Device.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.networkmanager.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.GetDevicesResponse
  ): zio.aws.networkmanager.model.GetDevicesResponse.ReadOnly = new Wrapper(
    impl
  )
}
