package zio.aws.networkmanager.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkmanager.model.primitives.{
  ConstrainedString,
  DateTime,
  Integer,
  CoreNetworkPolicyDocument,
  CoreNetworkId
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class CoreNetworkPolicy(
    coreNetworkId: Optional[CoreNetworkId] = Optional.Absent,
    policyVersionId: Optional[Integer] = Optional.Absent,
    alias: Optional[zio.aws.networkmanager.model.CoreNetworkPolicyAlias] =
      Optional.Absent,
    description: Optional[ConstrainedString] = Optional.Absent,
    createdAt: Optional[DateTime] = Optional.Absent,
    changeSetState: Optional[zio.aws.networkmanager.model.ChangeSetState] =
      Optional.Absent,
    policyErrors: Optional[
      Iterable[zio.aws.networkmanager.model.CoreNetworkPolicyError]
    ] = Optional.Absent,
    policyDocument: Optional[CoreNetworkPolicyDocument] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.CoreNetworkPolicy = {
    import CoreNetworkPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.CoreNetworkPolicy
      .builder()
      .optionallyWith(
        coreNetworkId.map(value =>
          CoreNetworkId.unwrap(value): java.lang.String
        )
      )(_.coreNetworkId)
      .optionallyWith(policyVersionId.map(value => value: java.lang.Integer))(
        _.policyVersionId
      )
      .optionallyWith(alias.map(value => value.unwrap))(_.alias)
      .optionallyWith(
        description.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(createdAt.map(value => DateTime.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(changeSetState.map(value => value.unwrap))(
        _.changeSetState
      )
      .optionallyWith(
        policyErrors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.policyErrors)
      .optionallyWith(
        policyDocument.map(value =>
          CoreNetworkPolicyDocument.unwrap(value): java.lang.String
        )
      )(_.policyDocument)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.CoreNetworkPolicy.ReadOnly =
    zio.aws.networkmanager.model.CoreNetworkPolicy.wrap(buildAwsValue())
}
object CoreNetworkPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.CoreNetworkPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.CoreNetworkPolicy =
      zio.aws.networkmanager.model.CoreNetworkPolicy(
        coreNetworkId.map(value => value),
        policyVersionId.map(value => value),
        alias.map(value => value),
        description.map(value => value),
        createdAt.map(value => value),
        changeSetState.map(value => value),
        policyErrors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        policyDocument.map(value => value)
      )
    def coreNetworkId: Optional[CoreNetworkId]
    def policyVersionId: Optional[Integer]
    def alias: Optional[zio.aws.networkmanager.model.CoreNetworkPolicyAlias]
    def description: Optional[ConstrainedString]
    def createdAt: Optional[DateTime]
    def changeSetState: Optional[zio.aws.networkmanager.model.ChangeSetState]
    def policyErrors: Optional[
      List[zio.aws.networkmanager.model.CoreNetworkPolicyError.ReadOnly]
    ]
    def policyDocument: Optional[CoreNetworkPolicyDocument]
    def getCoreNetworkId: ZIO[Any, AwsError, CoreNetworkId] =
      AwsError.unwrapOptionField("coreNetworkId", coreNetworkId)
    def getPolicyVersionId: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("policyVersionId", policyVersionId)
    def getAlias: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.CoreNetworkPolicyAlias
    ] = AwsError.unwrapOptionField("alias", alias)
    def getDescription: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("description", description)
    def getCreatedAt: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getChangeSetState
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.ChangeSetState] =
      AwsError.unwrapOptionField("changeSetState", changeSetState)
    def getPolicyErrors: ZIO[Any, AwsError, List[
      zio.aws.networkmanager.model.CoreNetworkPolicyError.ReadOnly
    ]] = AwsError.unwrapOptionField("policyErrors", policyErrors)
    def getPolicyDocument: ZIO[Any, AwsError, CoreNetworkPolicyDocument] =
      AwsError.unwrapOptionField("policyDocument", policyDocument)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.CoreNetworkPolicy
  ) extends zio.aws.networkmanager.model.CoreNetworkPolicy.ReadOnly {
    override val coreNetworkId: Optional[CoreNetworkId] = zio.aws.core.internal
      .optionalFromNullable(impl.coreNetworkId())
      .map(value =>
        zio.aws.networkmanager.model.primitives.CoreNetworkId(value)
      )
    override val policyVersionId: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.policyVersionId())
      .map(value => value: Integer)
    override val alias
        : Optional[zio.aws.networkmanager.model.CoreNetworkPolicyAlias] =
      zio.aws.core.internal
        .optionalFromNullable(impl.alias())
        .map(value =>
          zio.aws.networkmanager.model.CoreNetworkPolicyAlias.wrap(value)
        )
    override val description: Optional[ConstrainedString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.networkmanager.model.primitives.ConstrainedString(value)
        )
    override val createdAt: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.networkmanager.model.primitives.DateTime(value))
    override val changeSetState
        : Optional[zio.aws.networkmanager.model.ChangeSetState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.changeSetState())
        .map(value => zio.aws.networkmanager.model.ChangeSetState.wrap(value))
    override val policyErrors: Optional[
      List[zio.aws.networkmanager.model.CoreNetworkPolicyError.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.policyErrors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkmanager.model.CoreNetworkPolicyError.wrap(item)
        }.toList
      )
    override val policyDocument: Optional[CoreNetworkPolicyDocument] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyDocument())
        .map(value =>
          zio.aws.networkmanager.model.primitives
            .CoreNetworkPolicyDocument(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.CoreNetworkPolicy
  ): zio.aws.networkmanager.model.CoreNetworkPolicy.ReadOnly = new Wrapper(impl)
}
