package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AcceptAttachmentResponse(
    attachment: Optional[zio.aws.networkmanager.model.Attachment] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.AcceptAttachmentResponse = {
    import AcceptAttachmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.AcceptAttachmentResponse
      .builder()
      .optionallyWith(attachment.map(value => value.buildAwsValue()))(
        _.attachment
      )
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.AcceptAttachmentResponse.ReadOnly =
    zio.aws.networkmanager.model.AcceptAttachmentResponse.wrap(buildAwsValue())
}
object AcceptAttachmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.AcceptAttachmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.AcceptAttachmentResponse =
      zio.aws.networkmanager.model
        .AcceptAttachmentResponse(attachment.map(value => value.asEditable))
    def attachment: Optional[zio.aws.networkmanager.model.Attachment.ReadOnly]
    def getAttachment
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.Attachment.ReadOnly] =
      AwsError.unwrapOptionField("attachment", attachment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.AcceptAttachmentResponse
  ) extends zio.aws.networkmanager.model.AcceptAttachmentResponse.ReadOnly {
    override val attachment
        : Optional[zio.aws.networkmanager.model.Attachment.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attachment())
        .map(value => zio.aws.networkmanager.model.Attachment.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.AcceptAttachmentResponse
  ): zio.aws.networkmanager.model.AcceptAttachmentResponse.ReadOnly =
    new Wrapper(impl)
}
