package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{ConstrainedString, Integer}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PathComponent(
    sequence: Optional[Integer] = Optional.Absent,
    resource: Optional[zio.aws.networkmanager.model.NetworkResourceSummary] =
      Optional.Absent,
    destinationCidrBlock: Optional[ConstrainedString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.PathComponent = {
    import PathComponent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.PathComponent
      .builder()
      .optionallyWith(sequence.map(value => value: java.lang.Integer))(
        _.sequence
      )
      .optionallyWith(resource.map(value => value.buildAwsValue()))(_.resource)
      .optionallyWith(
        destinationCidrBlock.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.destinationCidrBlock)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.PathComponent.ReadOnly =
    zio.aws.networkmanager.model.PathComponent.wrap(buildAwsValue())
}
object PathComponent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.PathComponent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.PathComponent =
      zio.aws.networkmanager.model.PathComponent(
        sequence.map(value => value),
        resource.map(value => value.asEditable),
        destinationCidrBlock.map(value => value)
      )
    def sequence: Optional[Integer]
    def resource
        : Optional[zio.aws.networkmanager.model.NetworkResourceSummary.ReadOnly]
    def destinationCidrBlock: Optional[ConstrainedString]
    def getSequence: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("sequence", sequence)
    def getResource: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.NetworkResourceSummary.ReadOnly
    ] = AwsError.unwrapOptionField("resource", resource)
    def getDestinationCidrBlock: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("destinationCidrBlock", destinationCidrBlock)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.PathComponent
  ) extends zio.aws.networkmanager.model.PathComponent.ReadOnly {
    override val sequence: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.sequence())
      .map(value => value: Integer)
    override val resource: Optional[
      zio.aws.networkmanager.model.NetworkResourceSummary.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.resource())
      .map(value =>
        zio.aws.networkmanager.model.NetworkResourceSummary.wrap(value)
      )
    override val destinationCidrBlock: Optional[ConstrainedString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationCidrBlock())
        .map(value =>
          zio.aws.networkmanager.model.primitives.ConstrainedString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.PathComponent
  ): zio.aws.networkmanager.model.PathComponent.ReadOnly = new Wrapper(impl)
}
