package zio.aws.networkmanager.model
import scala.jdk.CollectionConverters.*
sealed trait LinkAssociationState {
  def unwrap: software.amazon.awssdk.services.networkmanager.model.LinkAssociationState
}
object LinkAssociationState {
  def wrap(
      value: software.amazon.awssdk.services.networkmanager.model.LinkAssociationState
  ): zio.aws.networkmanager.model.LinkAssociationState = value match {
    case software.amazon.awssdk.services.networkmanager.model.LinkAssociationState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.networkmanager.model.LinkAssociationState.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.networkmanager.model.LinkAssociationState.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.networkmanager.model.LinkAssociationState.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.networkmanager.model.LinkAssociationState.DELETED =>
      val r = DELETED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.networkmanager.model.LinkAssociationState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.LinkAssociationState =
      software.amazon.awssdk.services.networkmanager.model.LinkAssociationState.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING
      extends zio.aws.networkmanager.model.LinkAssociationState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.LinkAssociationState =
      software.amazon.awssdk.services.networkmanager.model.LinkAssociationState.PENDING
  }
  case object AVAILABLE
      extends zio.aws.networkmanager.model.LinkAssociationState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.LinkAssociationState =
      software.amazon.awssdk.services.networkmanager.model.LinkAssociationState.AVAILABLE
  }
  case object DELETING
      extends zio.aws.networkmanager.model.LinkAssociationState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.LinkAssociationState =
      software.amazon.awssdk.services.networkmanager.model.LinkAssociationState.DELETING
  }
  case object DELETED
      extends zio.aws.networkmanager.model.LinkAssociationState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.LinkAssociationState =
      software.amazon.awssdk.services.networkmanager.model.LinkAssociationState.DELETED
  }
}
