package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteSiteResponse(
    site: Optional[zio.aws.networkmanager.model.Site] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.DeleteSiteResponse = {
    import DeleteSiteResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.DeleteSiteResponse
      .builder()
      .optionallyWith(site.map(value => value.buildAwsValue()))(_.site)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.DeleteSiteResponse.ReadOnly =
    zio.aws.networkmanager.model.DeleteSiteResponse.wrap(buildAwsValue())
}
object DeleteSiteResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.DeleteSiteResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.DeleteSiteResponse =
      zio.aws.networkmanager.model
        .DeleteSiteResponse(site.map(value => value.asEditable))
    def site: Optional[zio.aws.networkmanager.model.Site.ReadOnly]
    def getSite
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.Site.ReadOnly] =
      AwsError.unwrapOptionField("site", site)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.DeleteSiteResponse
  ) extends zio.aws.networkmanager.model.DeleteSiteResponse.ReadOnly {
    override val site: Optional[zio.aws.networkmanager.model.Site.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.site())
        .map(value => zio.aws.networkmanager.model.Site.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.DeleteSiteResponse
  ): zio.aws.networkmanager.model.DeleteSiteResponse.ReadOnly = new Wrapper(
    impl
  )
}
