package zio.aws.networkmanager.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkmanager.model.primitives.{DateTime, ConstrainedString}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class CoreNetworkChangeEvent(
    `type`: Optional[zio.aws.networkmanager.model.ChangeType] = Optional.Absent,
    action: Optional[zio.aws.networkmanager.model.ChangeAction] =
      Optional.Absent,
    identifierPath: Optional[ConstrainedString] = Optional.Absent,
    eventTime: Optional[DateTime] = Optional.Absent,
    status: Optional[zio.aws.networkmanager.model.ChangeStatus] =
      Optional.Absent,
    values: Optional[
      zio.aws.networkmanager.model.CoreNetworkChangeEventValues
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.CoreNetworkChangeEvent = {
    import CoreNetworkChangeEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.CoreNetworkChangeEvent
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(action.map(value => value.unwrap))(_.action)
      .optionallyWith(
        identifierPath.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.identifierPath)
      .optionallyWith(eventTime.map(value => DateTime.unwrap(value): Instant))(
        _.eventTime
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(values.map(value => value.buildAwsValue()))(_.values)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.CoreNetworkChangeEvent.ReadOnly =
    zio.aws.networkmanager.model.CoreNetworkChangeEvent.wrap(buildAwsValue())
}
object CoreNetworkChangeEvent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.CoreNetworkChangeEvent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.CoreNetworkChangeEvent =
      zio.aws.networkmanager.model.CoreNetworkChangeEvent(
        `type`.map(value => value),
        action.map(value => value),
        identifierPath.map(value => value),
        eventTime.map(value => value),
        status.map(value => value),
        values.map(value => value.asEditable)
      )
    def `type`: Optional[zio.aws.networkmanager.model.ChangeType]
    def action: Optional[zio.aws.networkmanager.model.ChangeAction]
    def identifierPath: Optional[ConstrainedString]
    def eventTime: Optional[DateTime]
    def status: Optional[zio.aws.networkmanager.model.ChangeStatus]
    def values: Optional[
      zio.aws.networkmanager.model.CoreNetworkChangeEventValues.ReadOnly
    ]
    def getType: ZIO[Any, AwsError, zio.aws.networkmanager.model.ChangeType] =
      AwsError.unwrapOptionField("type", `type`)
    def getAction
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.ChangeAction] =
      AwsError.unwrapOptionField("action", action)
    def getIdentifierPath: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("identifierPath", identifierPath)
    def getEventTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("eventTime", eventTime)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.ChangeStatus] =
      AwsError.unwrapOptionField("status", status)
    def getValues: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.CoreNetworkChangeEventValues.ReadOnly
    ] = AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.CoreNetworkChangeEvent
  ) extends zio.aws.networkmanager.model.CoreNetworkChangeEvent.ReadOnly {
    override val `type`: Optional[zio.aws.networkmanager.model.ChangeType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.networkmanager.model.ChangeType.wrap(value))
    override val action: Optional[zio.aws.networkmanager.model.ChangeAction] =
      zio.aws.core.internal
        .optionalFromNullable(impl.action())
        .map(value => zio.aws.networkmanager.model.ChangeAction.wrap(value))
    override val identifierPath: Optional[ConstrainedString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identifierPath())
        .map(value =>
          zio.aws.networkmanager.model.primitives.ConstrainedString(value)
        )
    override val eventTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.eventTime())
      .map(value => zio.aws.networkmanager.model.primitives.DateTime(value))
    override val status: Optional[zio.aws.networkmanager.model.ChangeStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.networkmanager.model.ChangeStatus.wrap(value))
    override val values: Optional[
      zio.aws.networkmanager.model.CoreNetworkChangeEventValues.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.values())
      .map(value =>
        zio.aws.networkmanager.model.CoreNetworkChangeEventValues.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.CoreNetworkChangeEvent
  ): zio.aws.networkmanager.model.CoreNetworkChangeEvent.ReadOnly = new Wrapper(
    impl
  )
}
