package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  LinkId,
  DeviceId,
  GlobalNetworkId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class LinkAssociation(
    globalNetworkId: Optional[GlobalNetworkId] = Optional.Absent,
    deviceId: Optional[DeviceId] = Optional.Absent,
    linkId: Optional[LinkId] = Optional.Absent,
    linkAssociationState: Optional[
      zio.aws.networkmanager.model.LinkAssociationState
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.LinkAssociation = {
    import LinkAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.LinkAssociation
      .builder()
      .optionallyWith(
        globalNetworkId.map(value =>
          GlobalNetworkId.unwrap(value): java.lang.String
        )
      )(_.globalNetworkId)
      .optionallyWith(
        deviceId.map(value => DeviceId.unwrap(value): java.lang.String)
      )(_.deviceId)
      .optionallyWith(
        linkId.map(value => LinkId.unwrap(value): java.lang.String)
      )(_.linkId)
      .optionallyWith(linkAssociationState.map(value => value.unwrap))(
        _.linkAssociationState
      )
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.LinkAssociation.ReadOnly =
    zio.aws.networkmanager.model.LinkAssociation.wrap(buildAwsValue())
}
object LinkAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.LinkAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.LinkAssociation =
      zio.aws.networkmanager.model.LinkAssociation(
        globalNetworkId.map(value => value),
        deviceId.map(value => value),
        linkId.map(value => value),
        linkAssociationState.map(value => value)
      )
    def globalNetworkId: Optional[GlobalNetworkId]
    def deviceId: Optional[DeviceId]
    def linkId: Optional[LinkId]
    def linkAssociationState
        : Optional[zio.aws.networkmanager.model.LinkAssociationState]
    def getGlobalNetworkId: ZIO[Any, AwsError, GlobalNetworkId] =
      AwsError.unwrapOptionField("globalNetworkId", globalNetworkId)
    def getDeviceId: ZIO[Any, AwsError, DeviceId] =
      AwsError.unwrapOptionField("deviceId", deviceId)
    def getLinkId: ZIO[Any, AwsError, LinkId] =
      AwsError.unwrapOptionField("linkId", linkId)
    def getLinkAssociationState: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.LinkAssociationState
    ] = AwsError.unwrapOptionField("linkAssociationState", linkAssociationState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.LinkAssociation
  ) extends zio.aws.networkmanager.model.LinkAssociation.ReadOnly {
    override val globalNetworkId: Optional[GlobalNetworkId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalNetworkId())
        .map(value =>
          zio.aws.networkmanager.model.primitives.GlobalNetworkId(value)
        )
    override val deviceId: Optional[DeviceId] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceId())
      .map(value => zio.aws.networkmanager.model.primitives.DeviceId(value))
    override val linkId: Optional[LinkId] = zio.aws.core.internal
      .optionalFromNullable(impl.linkId())
      .map(value => zio.aws.networkmanager.model.primitives.LinkId(value))
    override val linkAssociationState
        : Optional[zio.aws.networkmanager.model.LinkAssociationState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.linkAssociationState())
        .map(value =>
          zio.aws.networkmanager.model.LinkAssociationState.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.LinkAssociation
  ): zio.aws.networkmanager.model.LinkAssociation.ReadOnly = new Wrapper(impl)
}
